function makePart( tex, mode )
	local fxs = { 'textured.fx', 'texturedAlpha.fx' }
	local layers = { 0, 1 }
	return { texture=tex, fx=fxs[mode], layer=layers[mode] }
end
function makeMesh( mesh, pts )
	return { name=mesh, parts=pts }
end
modeSimple = 1
modeAlpha = 2

partsRoad = {
	makePart( 'road01.png', modeSimple ),
}
partsRoadWide = {
	makePart( 'roadWide01.png', modeSimple ),
}
partsRoadWiden = {
	makePart( 'roadWiden01.png', modeSimple ),
}
partsRoadSide = {
	makePart( 'metal01.png', modeSimple ),
	makePart( 'roadSide01.png', modeAlpha ),
}
partsSquare = {
	makePart( 'square01.png', modeSimple ),
}

staticMeshes = {
makeMesh( 'Road', partsRoad	),
makeMesh( 'RoadTurn', partsRoad ),
makeMesh( 'RoadUp', partsRoad ),
makeMesh( 'Side', partsRoadSide ),
makeMesh( 'SideStart', partsRoadSide ),
makeMesh( 'SideTurnIn', partsRoadSide ),
makeMesh( 'SideTurnOut', partsRoadSide ),
makeMesh( 'SideUp', partsRoadSide ),
makeMesh( 'Border', partsRoad ),
makeMesh( 'BorderWiden1', partsRoad ),
makeMesh( 'BorderWiden2', partsRoad ),
makeMesh( 'RoadWide', partsRoadWide ),
makeMesh( 'RoadWiden', partsRoadWiden ),
makeMesh( 'TurnWide', partsRoadWide ),
makeMesh( 'TurnWide45', partsRoadWide ),
makeMesh( 'WideRise', partsRoadWide ),
makeMesh( 'Square', partsSquare ),
makeMesh( 'SquareUp', partsSquare ),
makeMesh( 'SquareCorner1', partsSquare ),
makeMesh( 'SquareCorner2', partsSquare ),
}

thingMeshes = {
makeMesh( 'o_sign', { makePart( 'sign01.png', modeSimple ) } ),
makeMesh( 'o_cone', { makePart( 'cone01.png', modeSimple ) } ),
makeMesh( 'o_marker', { makePart( 'rgb01.png', modeSimple ) } ),
makeMesh( 'Sphere', { makePart( 'rgb01.png', modeSimple ) } ),
}
