 #include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>


CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 2.0f, 4.0f );
	}
}
CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = i ? "monster" : "goom";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}
}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/level01.lua" );
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
		char buf[100];
		sprintf( buf, "score: %i", mScore[i] );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xFFFFFFFF
		);
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
	}
}

void CMyGame::onUpdate()
{
	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };

	for( int i = 0; i < VEHICLES; ++i ) {
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			++mScore[VEHICLES-i-1];
			continue;
		}
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1;
		if( GetAsyncKeyState(keyDown[i]) )
			accel -= 1;

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;

		mVehicle[i]->control( accel, turn );
	}

	CGameInfo::getInstance().getLevel().update();
}
