#include "stdafx.h"
#pragma hdrstop

#include <jam/GameSystem.h>
#include "MyGame.h"


INT WINAPI WinMain( HINSTANCE hInst, HINSTANCE, LPSTR, INT )
{
	CGameSystem* system = 0;
	try {
		system = new CGameSystem( CMyGame::getInstance() );
		
		if( SUCCEEDED( system->create( hInst ) ) )
			system->run();

		CMyGame::finalize();
		delete system;
	} catch( std::exception& e ) {
		std::string willExit = "\n\nThe application will now exit.";
		MessageBox( 0, (e.what()+willExit).c_str(), "Fatal error", MB_OK );
		return 0;
	}
	return 0;
}
