#include "../stdafx.h"
#pragma hdrstop

#include "EntityNameGenerator.h"
#include <dingus/utils/StringHelper.h>

std::string CEntityNameGenerator::generateName( const std::string& baseName )
{
	TStringIntMap::iterator it = mCounts.find( baseName );
	if( it == mCounts.end() ) {
		it = mCounts.insert( std::make_pair(baseName,0) ).first;
	}
	char buf[200];
	sprintf( buf, "%s%03i", baseName.c_str(), it->second++ );
	return buf;
}

void CEntityNameGenerator::takeName( const std::string& name, const std::string& baseName )
{
	// TBD: make more robust
	if( !dingus::CStringHelper::startsWith( name, baseName ) )
		return;

	TStringIntMap::iterator it = mCounts.find( baseName );
	if( it == mCounts.end() ) {
		it = mCounts.insert( std::make_pair(baseName,0) ).first;
	}
	std::string rest = name.substr( baseName.length(), name.length()-baseName.length() );
	int num = atoi( rest.c_str() );
	if( num >= it->second )
		it->second = num+1;
}
