#ifndef __JAMMER_H
#define __JAMMER_H

#include <unco/entity/Camera.h>
#include <unco/helpers/CameraController.h>
#include <unco/helpers/RenderTarget.h>
#include <dingus/collider-ode/Collidable.h>
#include <dingus/collider-ode/CollisionListener.h>
#include <dingus/pipeline/PipelineStage.h>
#include "EntityNameGenerator.h"
#include "jammer/JammerLevel.h"


class CJammerStaticEntity;
class CJammerThingEntity;
class CJammerTagInstance;

// --------------------------------------------------------------------------

enum eEditMode {
	MODE_CREATE = 0,
	MODE_LINK
};


// --------------------------------------------------------------------------

class CPickColListener : public dingus::ICollisionListener {
public:
	CPickColListener( int pickCategory ) : mPickCategoryBits(pickCategory), mActive(false), mMinDistance(1.0e6f), mMinColData(0) { }

	void	reset();
	SVector3 const& getMinPosition() const { return mMinPosition; }
	SVector3 const& getMinNormal() const { return mMinNormal; }
	float	getMinDistance() const { return mMinDistance; }
	void*	getMinColData() const { return mMinColData; }

	virtual void onCollide( dingus::CCollidable& me, dingus::CCollidable& him );

	bool isActive() const { return mActive; }
	void setActive( bool a ) { mActive = a; }

private:
	int			mPickCategoryBits;
	SVector3		mMinPosition;
	SVector3		mMinNormal;
	float			mMinDistance;
	void*			mMinColData;
	bool			mActive;
};


// --------------------------------------------------------------------------

class CJammer : public dingus::IPipelineStage {
public:
	CJammer();
	~CJammer();

	void	initialize();
	
	CJammerStaticEntity&	addStaticEntity( const std::string& className );
	CJammerThingEntity*		addThingEntity( const std::string& className );

	void	removeStaticEntity( CJammerStaticEntity& entity );
	void	removeThingEntity( CJammerThingEntity& entity );

	void	select();
	void	flipStaticLink( SVector3 const& flip ) const;
	void	moveStaticEntity( CJammerStaticEntity& entity ) const;
	void	linkStaticTags( CJammerTagInstance& tag1, CJammerTagInstance& tag2 ) const;

	//void	linkStaticTags( CJammerTagInstance& tag1, CJammerTagInstance& tag2 );

	unco::CCamera&	getCamera() { return *mCamera; }
	unco::CCameraController& getCameraController() { return mCameraController; }

	void	setPicker( float x, float y ) { mPickerX = x; mPickerY = y; }

	void	setEditMode( eEditMode m );
	eEditMode getEditMode() const { return mEditMode; }

	CJammerStaticEntity* getSelectedStatic() const { return mSelectedStatic; }
	CJammerThingEntity* getSelectedThing() const { return mSelectedThing; }
	CJammerTagInstance* getSelectedTag() const { return mSelectedTag; }
	CJammerTagInstance* getSelectedTagForLink() const { return mSelectedTagForLink; }
	void setSelectedTagForLink( CJammerTagInstance* tag ) { mSelectedTagForLink = tag; }

	CEntityNameGenerator& getNameGenerator() { return mNameGenerator; }
	CJammerLevel& getJamLevel() const { return *mJamLevel; }

	// IPipelineStage
	virtual void	perform();

	void	incLinkFrameCounter() { ++mLinkFrameCounter; }

private:
	//
	// viewing stuff
	unco::CRenderTarget		mRenderTarget;
	unco::CCamera*			mCamera;
	unco::CCameraController	mCameraController;

	//
	// edit stuff
	eEditMode				mEditMode;
	CJammerStaticEntity*	mSelectedStatic;
	CJammerThingEntity*		mSelectedThing;
	CJammerTagInstance*		mSelectedTag;
	CJammerTagInstance*		mSelectedTagForLink;
	int						mLinkFrameCounter;

	//
	// common stuff
	CEntityNameGenerator	mNameGenerator;
	CJammerLevel*			mJamLevel;

	//
	// picking stuff
	dingus::CCollidableRay	mPicker;
	float					mPickerX, mPickerY;
	CPickColListener		mPickStatic;
	CPickColListener		mPickThing;
	CPickColListener		mPickTag;
	float					mLastPickDistance;
};


#endif
