#include "stdafx.h"
#pragma hdrstop

#include "JammerLevelCreator.h"
#include "Jammer.h"
#include "jammer/JammerStaticEntity.h"
#include "jammer/JammerThingEntity.h"
#include <jam/level/Level.h>
#include <jam/level/GameInfo.h>
#include <jam/entity/EntityClasses.h>

CJammerLevelCreator::CJammerLevelCreator( CJammer& jammer )
:	mJammer(&jammer)
{
}

void CJammerLevelCreator::createStaticEntity(
		const std::string& name, const std::string& clazzName,
		const SMatrix4x4& matrix, bool flipCull )
{
	assert( mJammer );
	CLevel& level = CGameInfo::getInstance().getLevel();
	CStaticEntityClass const* clazz = CGameInfo::getInstance().getClasses().getStaticEntityClass( clazzName );
	assert( clazz );
	mJammer->getNameGenerator().takeName( name, clazzName );
	CJammerStaticEntity* e = new CJammerStaticEntity( name, *clazz, mJammer->getJamLevel(), 0, level.getVisStatic() );
	level.getStaticEntities().addEntity( e );
	e->getMatrix() = matrix;
	e->setCullMode( flipCull ? D3DCULL_CW : D3DCULL_CCW );
	e->attach();
}

void CJammerLevelCreator::createThingEntity(
		const std::string& name, const std::string& clazzName,
		const std::string& staticName, const SMatrix4x4& matrix )
{
	assert( mJammer );
	CLevel& level = CGameInfo::getInstance().getLevel();
	CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( clazzName );
	assert( clazz );
	mJammer->getNameGenerator().takeName( name, clazzName );
	CJammerThingEntity* e = new CJammerThingEntity( name, *clazz, 0, level.getVisThing() );
	CBaseEntity* eParent = level.getStaticEntities().findEntity( staticName ).get();
	assert( eParent );
	e->setParent( eParent );
	level.getThingEntities().addEntity( e );
	SMatrix4x4 invPar = eParent->getMatrix();
	invPar.invert();
	e->getMatrix() = matrix * invPar;
	e->attach();
}

void CJammerLevelCreator::createStaticLink(
		const std::string& entity1Name, const std::string& entity2Name,
		const std::string& tag1Name, const std::string& tag2Name,
		const SVector3& tag1flips, const SVector3& tag2flips )
{
	assert( mJammer );
	mJammer->incLinkFrameCounter();
	CLevel::TBaseEntityContainer& statics = CGameInfo::getInstance().getLevel().getStaticEntities();
	CJammerStaticEntity* e1 = (CJammerStaticEntity*)statics.findEntity(entity1Name).get();
	CJammerStaticEntity* e2 = (CJammerStaticEntity*)statics.findEntity(entity2Name).get();
	assert( e1 && e2 );
	if( !e1 || !e2 )
		return;
	e1->update();
	e2->update();
	CJammerTagInstance* tag1 = e1->findTagInstance(tag1Name);
	CJammerTagInstance* tag2 = e2->findTagInstance(tag2Name);
	tag1->setFlips( tag1flips );
	tag2->setFlips( tag2flips );
	assert( tag1 && tag2 );
	if( !tag1 || !tag2 )
		return;
	mJammer->linkStaticTags( *tag1, *tag2 );
	mJammer->moveStaticEntity( *e1 );
	mJammer->moveStaticEntity( *e2 );
}
