#include "stdafx.h"
#pragma hdrstop

#include "JammerSystem.h"
#include "Jammer.h"

#include <unco/kernel/Contexts.h>
#include <unco/kernel/AppContext.h>

#include <dingus/dxutils/D3DFont.h>

#include <dingus/kernel/SystemClock.h>
#include <dingus/kernel/D3DDevice.h>

#include <dingus/resource/SharedTextureBundle.h>
#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/resource/EffectBundle.h>
#include <dingus/resource/VertexDeclBundle.h>
#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/LuaWrapperBundle.h>
#include <dingus/resource/DeviceResource.h>
#include <dingus/resource/ReloadableBundle.h>
#include <dingus/resource/CollisionMeshBundle.h>

#include <dingus/renderer/RenderContext.h>
#include <dingus/renderer/RenderStage.h>
#include <dingus/visibility/VisibilityContext.h>
#include <dingus/visibility/VisibilityStage.h>
#include <dingus/portal/PortalContext.h>
#include <dingus/portal/PortalStage.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <dingus/collider-ode/CollisionStage.h>

#include <dingus/pipeline/Pipeline.h>

#include <dingus/gfx/geometry/DynamicVBManager.h>

#include <dingus/console/W32StdConsoleRenderingContext.h>
#include <dingus/console/D3DConsoleRenderingContext.h>


using namespace unco;


CJammerSystem::CJammerSystem( HWND renderWnd )
:	mAppStage(NULL),
	mAppInited( false )
{
	mCreationWidth		= 640;
	mCreationHeight 	= 480;
	mWindowTitle		= "Jammer";
	mStartFullscreen	= false;
	mShowCursorWhenFullscreen			= true;
	mEnumeration.mUsesDepthBuffer		= true;
	mEnumeration.mMinColorChannelBits	= 4;
	mEnumeration.mMinAlphaChannelBits	= 0;
	mEnumeration.mMinDepthBits			= 16;
	mEnumeration.mMinStencilBits		= 0;
	mDataPath = "../data/";

	mFont = new dingus::CD3DFont( "Arial", 10, dingus::CD3DFont::BOLD );

	mHWnd = renderWnd;

    create( AfxGetInstanceHandle() );
};


CJammerSystem::~CJammerSystem()
{
	delete mFont;
}


/**
 *  Initialization. Paired with shutdown().
 *  The window has been created and the IDirect3D9 interface has been
 *  created, but the device has not been created yet. Here you can
 *  perform application-related initialization and cleanup that does
 *  not depend on a device.
 */
HRESULT CJammerSystem::initialize()
{
	//
	// init console

	mStdConsoleCtx = new dingus::CW32StdConsoleRenderingContext( NULL );
	dingus::CConsole::getInstance().setDefaultRenderingContext( *mStdConsoleCtx );

	/**/
	dingus::CD3DTextBoxConsoleRenderingContext* ctxSystem = 
		new dingus::CD3DTextBoxConsoleRenderingContext( *mFont, 2, 2, 0x40FFFF80 );
	
	mD3DConsoleCtxs.push_back( ctxSystem );

	dingus::CConsole::getChannel( "system" ).setRenderingContext( *ctxSystem );
	/**/
	
	//
	// resources

	// NOTE: needs to init with complete path - the current dir may change
	// while running program
	char curdir[500];
	GetCurrentDirectory( 499, curdir );
	const std::string basePath = std::string(curdir) + '/' + mDataPath;
	dingus::CTextureBundle::init( basePath + "tex/" );
	dingus::CMeshBundle::init( basePath + "mesh/" );
	dingus::CEffectBundle::init( basePath + "fx/" );
	dingus::CCollisionMeshBundle::init( basePath + "mesh/" );
	dingus::CSharedTextureBundle::init();
	dingus::CVertexDeclBundle::init();
	dingus::CIndexBufferBundle::init();
	dingus::CLuaWrapperBundle::init( basePath + "script/" );

	dingus::CDynamicVBManager *vbManager = new dingus::CDynamicVBManager( 2 * 1024 * 1024 ); // 2 megabytes

	//
	// device dependant resources

	mDeviceManager = new dingus::CDeviceResourceManager();
	mDeviceManager->add( dingus::CSharedTextureBundle::getInstance() );
	mDeviceManager->add( *vbManager );
	mDeviceManager->add( dingus::CTextureBundle::getInstance() );
	mDeviceManager->add( dingus::CMeshBundle::getInstance() );
	mDeviceManager->add( dingus::CEffectBundle::getInstance() );
	mDeviceManager->add( dingus::CVertexDeclBundle::getInstance() );
	mDeviceManager->add( dingus::CIndexBufferBundle::getInstance() );

	//
	// reloadable resources

	mReloadableManager = new dingus::CReloadableBundleManager();
	mReloadableManager->add( dingus::CTextureBundle::getInstance() );
	mReloadableManager->add( dingus::CMeshBundle::getInstance() );
	mReloadableManager->add( dingus::CEffectBundle::getInstance() );
	mReloadableManager->add( dingus::CCollisionMeshBundle::getInstance() );

	//
	// contexts

	mPipeline = new dingus::CPipeline();
	mPortalPipeline = new dingus::CPipeline();

	CContextRegistry& ctxs = CContextRegistry::getInstance();
	ctxs.setContext( CTX_RENDER, new dingus::CRenderContext() );
	ctxs.setContext( CTX_VIS, new dingus::CVisibilityContext() );
	ctxs.setContext( CTX_PORTAL, new dingus::CPortalContext( *mPortalPipeline ) );
	ctxs.setContext( CTX_COLLISION, new dingus::CCollisionContext() );
	ctxs.setContext( CTX_DYNAVB, vbManager );

	//
	// pipeline


	dingus::IPipelineStage* stage;

	// app stage - dispatched thru self
	mPipeline->addStage( *this );

	// collision stage
	stage = new dingus::CCollisionStage( CContexts::getCollisionCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPipeline->addStage( *stage );

	// visibility stage - to portal subpipe
	stage = new dingus::CVisibilityStage( CContexts::getVisCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPortalPipeline->addStage( *stage );
	
	// render stage - to portal subpipe
	stage = new dingus::CRenderStage( CContexts::getRenderCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPortalPipeline->addStage( *stage );

	// portal stage
	stage = new dingus::CPortalStage( CContexts::getPortalCtx() );
	mCreatedPipelineStages.push_back( stage );
	mPipeline->addStage( *stage );

	return S_OK;
}


/**
 *  Called during device initialization, this code checks the display device
 *  for some minimum set of capabilities.
 */
HRESULT CJammerSystem::checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT format )
{
	//if( caps.DeviceType != D3DDEVTYPE_REF )
	//	return E_FAIL;
	return S_OK;
}



/**
 *  createDeviceObjects(). Paired with deleteDeviceObjects().
 *  The device has been created.  Resources that are not lost on
 *  Reset() can be created here -- resources in D3DPOOL_MANAGED, D3DPOOL_SCRATCH,
 *  or D3DPOOL_SYSTEMMEM. Image surfaces created via CreateImageSurface are never
 *  lost and can be created here. Vertex shaders and pixel shaders can also be
 *  created here as they are not lost on Reset().
 */
HRESULT CJammerSystem::createDeviceObjects()
{
	dingus::gD3DDevice = mD3DDevice;

	mFont->createDeviceObjects( *mD3DDevice );
	
	CAppContext::getInstance().setInfo( mBackBuffer.Width, mBackBuffer.Height, mFrameStats, mDeviceStats );

	mDeviceManager->createResource();

	if( !mAppInited ) {
		mAppInited = true;
	}

	CContexts::getRenderCtx().notifyChanged();

	return S_OK;
}


/**
 *  activateDeviceObjects(). Paired with passivateDeviceObjects().
 *  The device exists, but may have just been Reset(). Resources in
 *  D3DPOOL_DEFAULT and any other device state that persists during rendering
 *  should be set here.
 */
HRESULT CJammerSystem::activateDeviceObjects()
{
	mFont->activateDeviceObjects();
	CAppContext::getInstance().setInfo( mBackBuffer.Width, mBackBuffer.Height, mFrameStats, mDeviceStats );
	mDeviceManager->activateResource();
	return S_OK;
}


HRESULT CJammerSystem::performOneTime()
{
	dingus::CSystemClock& c = dingus::CSystemClock::getInstance();
	c.setTimes( mTime, mElapsedTime, c.getPerformCount()+1 );
	CAppContext::getInstance().setInfo( mBackBuffer.Width, mBackBuffer.Height, mFrameStats, mDeviceStats );


	//
	// matrices

	/*
	dingus::CRenderCamera& camera = unco::CContexts::getRenderCtx().getCamera();

	SMatrix4x4 worldMat;
	worldMat.identify();

	SMatrix4x4 camMat;
	camMat.identify();
	camMat.getOrigin().z = -6.0f;
	camera.setCameraMatrix( camMat );

	SMatrix4x4 projMat;
	unco::CAppContext& appCtx = unco::CAppContext::getInstance();
    //D3DXMatrixPerspectiveFovLH( &projMat, D3DX_PI/2.0f, (float)appCtx.getScreenWidth()/appCtx.getScreenHeight(), 0.5f, 200.0f );
	D3DXMatrixOrthoLH( &projMat, 16.0f, 12.0f, 0.5f, 40.0f );
	camera.setProjectionMatrix( projMat );

	dingus::gD3DDevice->SetTransform( D3DTS_WORLD, &worldMat );
	dingus::gD3DDevice->SetTransform( D3DTS_PROJECTION, &camera.getProjectionMatrix() );
	dingus::gD3DDevice->SetTransform( D3DTS_VIEW, &camera.getViewMatrix() );
	*/

	//
	// pipeline

	mPipeline->perform();

	//
	// stats

	/*
	dingus::CConsoleChannel& cc = dingus::CConsole::getChannel( "system" );
	cc.write( mFrameStats );
	cc.write( mDeviceStats );
	
	dingus::gD3DDevice->BeginScene();
	TD3DConsoleCtxVector::iterator it, itEnd = mD3DConsoleCtxs.end();
	for( it = mD3DConsoleCtxs.begin(); it != itEnd; ++it ) {
		(*it)->flush();
	}
	dingus::gD3DDevice->EndScene();
	*/
	
	return S_OK;
}


/**
 *  Overrrides the main WndProc, so the sample can do custom message handling
 *  (e.g. processing mouse, keyboard, or menu commands).
 */
LRESULT CJammerSystem::msgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	static bool reloadKeyPressed = false;
	switch( msg ) {
	case WM_KEYDOWN:
		if( wParam == VK_F5 )
			reloadKeyPressed = true;
		break;
	case WM_KEYUP:
		if( wParam == VK_F5 ) {
			if( reloadKeyPressed ) {
				mReloadableManager->reload();
				CContexts::getRenderCtx().notifyChanged();
			}
			reloadKeyPressed = false;
		}
	}
	return CD3DApplication::msgProc( hWnd, msg, wParam, lParam );
}


/**
 *  Invalidates device objects.  Paired with activateDeviceObjects().
 */
HRESULT CJammerSystem::passivateDeviceObjects()
{
	mFont->passivateDeviceObjects();
	mDeviceManager->passivateResource();
	return S_OK;
}

/**
 *  Paired with createDeviceObjects().
 *  Called when the app is exiting, or the device is being changed,
 *  this function deletes any device dependent objects.
 */
HRESULT CJammerSystem::deleteDeviceObjects()
{
	mFont->deleteDeviceObjects();
	mDeviceManager->deleteResource();
	dingus::gD3DDevice = NULL;
	return S_OK;
}


/**
 *  Paired with initialize().
 *  Called before the app exits, this function gives the app the chance
 *  to cleanup after itself.
 */
HRESULT CJammerSystem::shutdown()
{
	mDeviceManager->clear();
	delete mDeviceManager;

	mReloadableManager->clear();
	delete mReloadableManager;

	delete &CContexts::getRenderCtx();
	delete &CContexts::getVisCtx();
	delete &CContexts::getPortalCtx();
	delete &CContexts::getCollisionCtx();
	delete &CContexts::getDynamicVBManager();
	CContextRegistry::finalize();
	CAppContext::finalize();
	

	dingus::CTextureBundle::finalize();
	dingus::CMeshBundle::finalize();
	dingus::CEffectBundle::finalize();
	dingus::CVertexDeclBundle::finalize();
	dingus::CSharedTextureBundle::finalize();
	dingus::CIndexBufferBundle::finalize();
	dingus::CLuaWrapperBundle::finalize();
	dingus::CCollisionMeshBundle::finalize();

	dingus::stl_utils::wipe( mCreatedPipelineStages );
	delete mPipeline;
	delete mPortalPipeline;

	dingus::CSystemClock::finalize();
	dingus::stl_utils::wipe( mD3DConsoleCtxs );
	//dingus::CConsole::finalize(); // nono - bugs resource bundles

	return S_OK;
}
