#ifndef __JAMMER_SYSTEM_H
#define __JAMMER_SYSTEM_H

#include <dingus/dxutils/D3DApplication.h>
#include <dingus/pipeline/PipelineStage.h>

namespace dingus {
	class CDeviceResourceManager;
	class CReloadableBundleManager;
	class CPipeline;
	class CD3DFont;
	class IConsoleRenderingContext;
	class CD3DTextBoxConsoleRenderingContext;
	class IPipelineStage;
};


class CJammerSystem : public dingus::CD3DApplication, public dingus::IPipelineStage {
public:
	CJammerSystem( HWND renderWnd );
	virtual ~CJammerSystem();

	LRESULT msgProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

	void	resize() { handlePossibleSizeChange(); }

	void	render() { render3DEnvironment(); }

	// IPipelineStage
	virtual void perform() { if( mAppStage ) mAppStage->perform(); }

	void	setAppStage( dingus::IPipelineStage* appStage ) { mAppStage = appStage; }

protected:
	virtual HRESULT performOneTime();
	virtual HRESULT initialize();
	virtual HRESULT createDeviceObjects();
	virtual HRESULT activateDeviceObjects();
	virtual HRESULT passivateDeviceObjects();
	virtual HRESULT deleteDeviceObjects();
	virtual HRESULT shutdown();
	virtual HRESULT checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT bbFormat );

private:
	typedef std::vector<dingus::CD3DTextBoxConsoleRenderingContext*>	TD3DConsoleCtxVector;
	typedef std::vector<dingus::IPipelineStage*>	TPipelineStageVector;

private:
	dingus::IPipelineStage*				mAppStage;

	const char*							mDataPath;
	dingus::CDeviceResourceManager*		mDeviceManager;
	dingus::CReloadableBundleManager*	mReloadableManager;
	dingus::CPipeline*					mPipeline;
	dingus::CPipeline*					mPortalPipeline;
	dingus::CD3DFont*					mFont;
	dingus::IConsoleRenderingContext*	mStdConsoleCtx;
	TD3DConsoleCtxVector				mD3DConsoleCtxs;
	TPipelineStageVector				mCreatedPipelineStages;
	
	bool								mAppInited;
};


#endif
