#include "../stdafx.h"
#pragma hdrstop

#include "JammerStaticEntity.h"
#include "JammerLevel.h"
#include <jam/Resources.h>
#include <jam/entity/CollideClasses.h>

#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/kernel/SystemClock.h>


CJammerStaticEntity::CJammerStaticEntity( const std::string& name, const CStaticEntityClass& clazz, CJammerLevel& jamLevel, int colBits, unco::CVisibilityComponent& visComp )
:	CStaticEntity( name, clazz, colBits, false, visComp ),
	mJamLevel(&jamLevel),
	mSelectedOnFrame(-1),
	mIndicatedOnFrame(-1)
{
	// add tag instances
	CStaticEntityClass::TNameTagMap::const_iterator it, itEnd = clazz.getTags().end();
	mTagInstances.reserve( clazz.getTags().size() );
	mTagSpheres.reserve( clazz.getTags().size() );
	for( it = clazz.getTags().begin(); it != itEnd; ++it ) {
		mTagInstances.push_back( CJammerTagInstance( it->second ) );
		CJammerTagInstance& tagi = mTagInstances.back();
		tagi.setOwner( this ); // owner - this entity

		unco::CMeshComponent* tagMesh = new unco::CMeshComponent(
			*dingus::CMeshBundle::getInstance().getResourceById( R_MESH_TAG ),
			0,
			R_FX_TAGS,
			0,
			tagi.getWorldMatrix()
		);
		dingus::CEffectParams& params = tagMesh->getParams();
		params.addTexture( "tBase",
			*dingus::CTextureBundle::getInstance().getResourceById( R_TEX_TAG )
		);
		params.addColor4Ref( "vColor", tagi.getColor() );
		params.addInt( "dwCull", D3DCULL_NONE );

		addComponent( *tagMesh );
		jamLevel.getVisTags().addListener( *tagMesh );
		mTagMeshes.push_back( tagMesh );

		// create collision sphere for each
		unco::CColSphereComponent* col = new unco::CColSphereComponent( getWorldMatrix() );
		col->setRadius( 2.0f );
		col->getMatrix() = tagi.getTag().getMatrix();
		col->getCollidable().setCategoryBits( 1<<COL_UI_TAGS );
		col->getCollidable().setCollideBits( 1<<COL_UI_PICKER );
		col->getCollidable().setUserData( &tagi ); // data - tag instance
		mTagSpheres.push_back( col );
		addComponent( *col );
	}
}

CJammerStaticEntity::~CJammerStaticEntity()
{
	int n = mTagMeshes.size();
	int i;
	for( i = 0; i < n; ++i ) {
		unco::CMeshComponent* comp = mTagMeshes[i];
		mJamLevel->getVisTags().removeListener( *comp );
		CJammerTagInstance& tag = mTagInstances[i];
		if( tag.isLinked() ) {
			tag.getJammerLink()->setLink( NULL ); // unlink
		}
	}
}

CJammerTagInstance* CJammerStaticEntity::findTagInstance( const std::string& name )
{
	int n = mTagInstances.size();
	for( int i = 0; i < n; ++i ) {
		CJammerTagInstance& tag = mTagInstances[i];
		if( tag.getTag().getName() == name )
			return &tag;
	}
	return NULL;
}


void CJammerStaticEntity::updateColor( int frame )
{	
	if( mSelectedOnFrame == frame ) {
		setColor( 0x60C08080 );
	} else {
		setColor( mIndicatedOnFrame==frame ? 0x4070C070 : 0x40707070 );
	}
}

void CJammerStaticEntity::internalUpdate()
{
	CStaticEntity::internalUpdate();

	int frame = dingus::CSystemClock::getInstance().getPerformCount();
	updateColor( frame );

	int n = mTagInstances.size();
	for( int i = 0; i < n; ++i ) {
		CJammerTagInstance& tag = mTagInstances[i];
		SMatrix4x4& tagm = mTagSpheres[i]->getMatrix();
		tagm = tag.getTag().getMatrix();
		float size = tag.getSelectedOnFrame()==frame ? 5 : 3;
		tagm.getAxisX() *= size;
		tagm.getAxisY() *= size;
		tagm.getAxisZ() *= size;
		//mTagSpheres[i]->setPosition( tag.getWorldMatrix().getOrigin() );
		tag.updateColor(frame);
		tag.getWorldMatrix() = tag.getTag().getMatrix() * getWorldMatrix();
		tag.getWorldMatrix().getAxisX() *= size;
		tag.getWorldMatrix().getAxisY() *= size;
		tag.getWorldMatrix().getAxisZ() *= size;
	}
}
