#ifndef __JAMMER_STATIC_ENTITY_H
#define __JAMMER_STATIC_ENTITY_H

#include <jam/entity/StaticEntity.h>
#include "JammerTag.h"

class CJammerLevel;


class CJammerStaticEntity : public CStaticEntity {
public:
	typedef std::vector<CJammerTagInstance>			TTagInstanceVector;
	typedef std::vector<unco::CColSphereComponent*>	TColSphereVector;

public:
	CJammerStaticEntity( const std::string& name, const CStaticEntityClass& clazz, CJammerLevel& jamLevel, int colBits, unco::CVisibilityComponent& visComp );
	virtual ~CJammerStaticEntity();

	TTagInstanceVector const& getTagInstances() const { return mTagInstances; }
	TTagInstanceVector& getTagInstances() { return mTagInstances; }

	CJammerTagInstance* findTagInstance( const std::string& name );

	void	setSelectedOnFrame( int frame ) { mSelectedOnFrame = frame; }
	int		getSelectedOnFrame() const { return mSelectedOnFrame; }

	void	setIndicatedOnFrame( int frame ) { mIndicatedOnFrame = frame; }
	int		getIndicatedOnFrame() const { return mIndicatedOnFrame; }

protected:
	virtual void internalUpdate();
	void	updateColor( int frame );

private:
	TTagInstanceVector		mTagInstances;
	TMeshCompVector			mTagMeshes;
	TColSphereVector		mTagSpheres;

	CJammerLevel*	mJamLevel;

	int			mSelectedOnFrame;
	int			mIndicatedOnFrame;
};


#endif
