#ifndef __JAMMER_TAG_H
#define __JAMMER_TAG_H

#include <jam/entity/Tag.h>


class CJammerTagInstance : public CTagInstance {
public:
	CJammerTagInstance( const CTag& tag );

	const D3DXCOLOR& getColor() const { return mColor; }

	void	setSelectedOnFrame( int frame ) { mSelectedOnFrame = frame; }
	int		getSelectedOnFrame() const { return mSelectedOnFrame; }

	int		getVisitedOnFrame() const { return mVisitedOnFrame; }
	void	setVisitedOnFrame( int frame ) { mVisitedOnFrame = frame; }

	const CJammerTagInstance* getJammerLink() const { return reinterpret_cast<CJammerTagInstance*>(getLink()); }
	CJammerTagInstance* getJammerLink() { return reinterpret_cast<CJammerTagInstance*>(getLink()); }

	void	updateColor( int frame );
	
private:
	int			mSelectedOnFrame;
	int			mVisitedOnFrame;
	D3DXCOLOR	mColor;
};


#endif
