#include "../stdafx.h"
#pragma hdrstop

#include "JammerThingEntity.h"
#include <dingus/kernel/SystemClock.h>
#include <jam/entity/CollideClasses.h>


CJammerThingEntity::CJammerThingEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp )
:	CBaseEntity( name, clazz, 1<<COL_ENTITY_THING, colBits, false, visComp ),
	mSelectedOnFrame(-1),
	mIndicatedOnFrame(-1)
{
}

CJammerThingEntity::~CJammerThingEntity()
{
}

void CJammerThingEntity::updateColor( int frame )
{	
	if( mSelectedOnFrame == frame ) {
		setColor( 0x60C08080 );
	} else {
		setColor( mIndicatedOnFrame==frame ? 0x4070C070 : 0x40707070 );
	}
}

void CJammerThingEntity::internalUpdate()
{
	int frame = dingus::CSystemClock::getInstance().getPerformCount();
	updateColor( frame );
}
