#ifndef __JAMMER_THING_ENTITY_H
#define __JAMMER_THING_ENTITY_H

#include <jam/entity/BaseEntity.h>


class CJammerThingEntity : public CBaseEntity {
public:
	CJammerThingEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp );
	virtual ~CJammerThingEntity();

	void	setSelectedOnFrame( int frame ) { mSelectedOnFrame = frame; }
	int		getSelectedOnFrame() const { return mSelectedOnFrame; }

	void	setIndicatedOnFrame( int frame ) { mIndicatedOnFrame = frame; }
	int		getIndicatedOnFrame() const { return mIndicatedOnFrame; }

protected:
	virtual void internalUpdate();
	void	updateColor( int frame );

private:
	int			mSelectedOnFrame;
	int			mIndicatedOnFrame;
};


#endif
