#include "../stdafx.h"
#pragma hdrstop

#include "../JammerSystem.h"
#include "../Jammer.h"
#include "JammerApp.h"
#include "JammerDoc.h"
#include "../JammerLevelCreator.h"
#include "../jammer/JammerLevel.h"
#include "../jammer/JammerStaticEntity.h"
#include "../jammer/JammerThingEntity.h"
#include <dingus/kernel/SystemClock.h>
#include <jam/level/Level.h>
#include <jam/level/GameInfo.h>
#include <jam/level/LevelSerializer.h>

// --------------------------------------------------------------------------
// CJammerDoc

IMPLEMENT_DYNCREATE(CJammerDoc, CDocument)

BEGIN_MESSAGE_MAP(CJammerDoc, CDocument)
	//{{AFX_MSG_MAP(CJammerDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// --------------------------------------------------------------------------
// CJammerDoc construction/destruction

CJammerDoc::CJammerDoc()
:	mSystem(NULL),
	mJammer(NULL)
{
}

CJammerDoc::~CJammerDoc()
{
	if( mSystem ) {
		mSystem->close();
		delete mSystem;
		mSystem = NULL;
	}
}

BOOL CJammerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	assert( !mJammer );

	// will initialize in realInitialize

	return TRUE;
}

void CJammerDoc::realInitialize( HWND renderWnd )
{
	mRenderWnd = renderWnd;
	if( !mSystem ) {
		mSystem = new CJammerSystem( renderWnd );
	}
	if( !mJammer ) { // may be already created when opening a doc. MFC :(
		mJammer = new CJammer();
		mSystem->setAppStage( mJammer );
		mJammer->initialize();
	}
	
	mJammer->setEditMode( MODE_CREATE );
}


void CJammerDoc::DeleteContents() 
{
	if( mJammer ) {
		CGameInfo::finalize();
		if( mSystem )
			mSystem->setAppStage( NULL );
		delete mJammer;
		mJammer = NULL;
	}
	CDocument::DeleteContents();
}


// --------------------------------------------------------------------------
// CJammerDoc commands

BOOL CJammerDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	DeleteContents();
	realInitialize( mRenderWnd );

	assert( mJammer );
	CJammerLevelCreator creator( *mJammer );
	CLevelFileReader::read( lpszPathName, creator );
	return TRUE;
}

BOOL CJammerDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	CLevelFileWriter w( lpszPathName );
	CLevel& level = CGameInfo::getInstance().getLevel();

	//
	// static entities

	w.beginStaticEntities();
	CLevel::TBaseEntityContainer::TEntityMap::const_iterator sit, sitEnd = level.getStaticEntities().getEntities().end();
	for( sit = level.getStaticEntities().getEntities().begin(); sit != sitEnd; ++sit ) {
		CJammerStaticEntity const* e = reinterpret_cast<CJammerStaticEntity*>(sit->second.get());
		w.writeStaticEntity( e->getName(), e->getClass().getName(), e->getWorldMatrix(), e->getCullMode()==D3DCULL_CW );
	}
	w.endStaticEntities();

	//
	// thing entities

	w.beginThingEntities();
	CLevel::TBaseEntityContainer::TEntityMap::const_iterator thit, thitEnd = level.getThingEntities().getEntities().end();
	for( thit = level.getThingEntities().getEntities().begin(); thit != thitEnd; ++thit ) {
		CJammerThingEntity const* e = reinterpret_cast<CJammerThingEntity*>(thit->second.get());
		w.writeThingEntity( e->getName(), e->getClass().getName(), ((CJammerStaticEntity&)e->getParent()).getName(), e->getWorldMatrix() );
	}
	w.endThingEntities();

	//
	// static entity tags

	int frame = dingus::CSystemClock::getInstance().getPerformCount();
	w.beginStaticLinks();
	for( sit = level.getStaticEntities().getEntities().begin(); sit != sitEnd; ++sit ) {
		CJammerStaticEntity* e = reinterpret_cast<CJammerStaticEntity*>(sit->second.get());
		CJammerStaticEntity::TTagInstanceVector::iterator it, itEnd = e->getTagInstances().end();
		for( it = e->getTagInstances().begin(); it != itEnd; ++it ) {
			CJammerTagInstance& tag = *it;
			if( tag.getVisitedOnFrame() == frame )
				continue;
			tag.setVisitedOnFrame( frame );
			if( !tag.isLinked() )
				continue;
			tag.getJammerLink()->setVisitedOnFrame( frame );
			w.writeStaticLink(
				((CStaticEntity const*)tag.getOwner())->getName(),
				((CStaticEntity const*)tag.getJammerLink()->getOwner())->getName(),
				tag.getTag().getName(),
				tag.getJammerLink()->getTag().getName(),
				tag.getFlips(),
				tag.getJammerLink()->getFlips()
				);
		}
	}
	w.endStaticLinks();

	return TRUE;
}
