#include "../stdafx.h"
#pragma hdrstop

#include "JammerApp.h"
#include "JammerView.h"
#include "NameDialog.h"
#include "../Jammer.h"
#include "../JammerSystem.h"
#include "../jammer/JammerStaticEntity.h"
#include "../jammer/JammerThingEntity.h"
#include <jam/entity/EntityClasses.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>

// --------------------------------------------------------------------------
// CJammerView

IMPLEMENT_DYNCREATE(CJammerView, CFormView)

BEGIN_MESSAGE_MAP(CJammerView, CFormView)
	//{{AFX_MSG_MAP(CJammerView)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_BTN_STATIC_ADD, OnBtnStaticAdd)
	ON_WM_RBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_EDIT_CREATEMODE, OnEditCreatemode)
	ON_COMMAND(ID_EDIT_LINKMODE, OnEditLinkmode)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CREATEMODE, OnUpdateEditCreatemode)
	ON_UPDATE_COMMAND_UI(ID_EDIT_LINKMODE, OnUpdateEditLinkmode)
	ON_COMMAND(ID_LINK_FLIPX, OnLinkFlipx)
	ON_UPDATE_COMMAND_UI(ID_LINK_FLIPX, OnUpdateLinkFlipx)
	ON_COMMAND(ID_LINK_FLIPY, OnLinkFlipy)
	ON_UPDATE_COMMAND_UI(ID_LINK_FLIPY, OnUpdateLinkFlipy)
	ON_COMMAND(ID_LINK_FLIPZ, OnLinkFlipz)
	ON_UPDATE_COMMAND_UI(ID_LINK_FLIPZ, OnUpdateLinkFlipz)
	ON_COMMAND(ID_LINK_OTHER, OnLinkOther)
	ON_UPDATE_COMMAND_UI(ID_LINK_OTHER, OnUpdateLinkOther)
	ON_COMMAND(ID_LINK_UNLINK, OnLinkUnlink)
	ON_UPDATE_COMMAND_UI(ID_LINK_UNLINK, OnUpdateLinkUnlink)
	ON_COMMAND(ID_CREATE_DELETE, OnCreateDelete)
	ON_UPDATE_COMMAND_UI(ID_CREATE_DELETE, OnUpdateCreateDelete)
	ON_COMMAND(ID_VIEW_FOCUS, OnViewFocus)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FOCUS, OnUpdateViewFocus)
	ON_BN_CLICKED(IDC_BTN_THING_ADD, OnBtnThingAdd)
	ON_COMMAND(ID_CREATE_TURNLEFT, OnCreateTurnleft)
	ON_UPDATE_COMMAND_UI(ID_CREATE_TURNLEFT, OnUpdateCreateTurnleft)
	ON_COMMAND(ID_CREATE_TURNRIGHT, OnCreateTurnright)
	ON_UPDATE_COMMAND_UI(ID_CREATE_TURNRIGHT, OnUpdateCreateTurnright)
	ON_COMMAND(ID_EDIT_RENAME, OnEditRename)
	ON_UPDATE_COMMAND_UI(ID_EDIT_RENAME, OnUpdateEditRename)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// --------------------------------------------------------------------------
// CJammerView construction/destruction

CJammerView::CJammerView()
:	CFormView(CJammerView::IDD),
	mLMouseUp(true)
{
	//{{AFX_DATA_INIT(CJammerView)
	//}}AFX_DATA_INIT
}

CJammerView::~CJammerView()
{
}

void CJammerView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CJammerView)
	DDX_Control(pDX, IDC_CMB_THINGS, mComboThings);
	DDX_Control(pDX, IDC_S_EDITMODE, mStaticEditmode);
	DDX_Control(pDX, IDC_S_SEL, mStaticSelection);
	DDX_Control(pDX, IDC_S_LINK_SEL, mStaticLinkSel);
	DDX_Control(pDX, IDC_S_LINK_INSTR, mStaticLinkInstr);
	DDX_Control(pDX, IDC_CMB_STATICS, mComboStatics);
	DDX_Control(pDX, IDC_RENDER_AREA, mRenderArea);
	//}}AFX_DATA_MAP
}

BOOL CJammerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	return CFormView::PreCreateWindow(cs);
}

void CJammerView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	//mRenderArea.SetWindowPos( NULL, 0, 0, 640, 480, SWP_NOMOVE | SWP_NOZORDER | SWP_NOOWNERZORDER );
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	RECT r, rown;
	mRenderArea.GetWindowRect( &r );
	GetWindowRect( &rown );

	SetScrollSizes( MM_TEXT, CSize(r.right-rown.left, r.bottom-rown.top) );

	getDocument().realInitialize( mRenderArea.GetSafeHwnd() );

	OnEditCreatemode();

	mStaticSelection.SetWindowText("");

	CJammer& jammer = *getDocument().getJammer();
	mViewingDistance = 80.0f;
	SMatrix4x4& camMat = jammer.getCamera().getMatrix();
	camMat.identify();
	camMat.getOrigin().z = -mViewingDistance;
	jammer.getCameraController().arcBallSetDistance( mViewingDistance );

	initScannedStuff();
}


// --------------------------------------------------------------------------
//  general msg handlers
// --------------------------------------------------------------------------

void CJammerView::OnSize(UINT nType, int cx, int cy) 
{
	CFormView::OnSize(nType, cx, cy);

	if( !getDocument().getSystem() )
		return;

	CPoint zeroMainPt(0,0);
	ClientToScreen( &zeroMainPt );
	CPoint zeroRenderPt(0,0);
	mRenderArea.ClientToScreen( &zeroRenderPt );
	CPoint renderPt = zeroRenderPt - zeroMainPt;

	RECT mainRect;
	GetClientRect( &mainRect );

	int xx = mainRect.right - renderPt.x - 3;
	int yy = mainRect.bottom - renderPt.y - 3;

	mRenderArea.SetWindowPos( NULL, 0, 0, xx, yy, SWP_NOMOVE | SWP_NOZORDER | SWP_NOOWNERZORDER );

	getDocument().getSystem()->resize();
	redraw();
}

void CJammerView::OnDraw(CDC* pDC) 
{
	CFormView::OnDraw( pDC );
	redraw();
}

void CJammerView::redraw()
{
	if( !getDocument().getSystem() )
		return;
	if( getDocument().getSystem()->isActive() )
		getDocument().getSystem()->render();
}


// --------------------------------------------------------------------------
//  button handlers
// --------------------------------------------------------------------------


void CJammerView::OnBtnStaticAdd() 
{
	if( IsDlgButtonChecked(IDC_BTN_STATIC_ADD) ) {
		if( mComboStatics.GetCurSel() != CB_ERR ) {
			CheckDlgButton( IDC_BTN_THING_ADD, 0 );
		} else {
			CheckDlgButton( IDC_BTN_STATIC_ADD, 0 );
		}
	}
}

void CJammerView::OnBtnThingAdd() 
{
	if( IsDlgButtonChecked(IDC_BTN_THING_ADD) ) {
		if( mComboThings.GetCurSel() != CB_ERR ) {
			CheckDlgButton( IDC_BTN_STATIC_ADD, 0 );
		} else {
			CheckDlgButton( IDC_BTN_THING_ADD, 0 );
		}
	}
}

void CJammerView::initScannedStuff()
{
	CEntityClasses const& clazzes = CGameInfo::getInstance().getClasses();

	// static mesh classes
	mComboStatics.ResetContent();
	CEntityClasses::TStaticEntityClassMap::const_iterator mit, mitEnd = clazzes.getStaticEntityClasses().end();
	for( mit = clazzes.getStaticEntityClasses().begin(); mit != mitEnd; ++mit ) {
		mComboStatics.AddString( mit->first.c_str() );
	}

	// thing classes
	mComboThings.ResetContent();
	CEntityClasses::TEntityClassMap::const_iterator thit, thitEnd = clazzes.getThingEntityClasses().end();
	for( thit = clazzes.getThingEntityClasses().begin(); thit != thitEnd; ++thit ) {
		mComboThings.AddString( thit->first.c_str() );
	}

	UpdateData(FALSE);
}

bool CJammerView::pixelsToScreen( int px, int py, float& x, float& y ) const
{
	CRect r, ownR;
	GetWindowRect( ownR );
	mRenderArea.GetWindowRect( r );
	px += ownR.left;
	py += ownR.top;
	if( r.PtInRect(CPoint(px,py)) ) {
		px -= r.left;
		py -= r.top;
		py += 2; // HACK
		int width = r.right - r.left;
		int height = r.bottom - r.top;
		x = (float)(px-width/2) / (width/2);
		y = (float)(py-height/2) / (height/2);
		return true;
	} else {
		return false;
	}
}


// --------------------------------------------------------------------------
//  mouse processing
// --------------------------------------------------------------------------


void CJammerView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CFormView::OnRButtonDown(nFlags, point);
	
	float x, y;
	if( !pixelsToScreen( point.x, point.y, x, y ) )
		return;

	CJammer& jammer = *getDocument().getJammer();
	jammer.setPicker( x, y );
	jammer.getCameraController().arcBallSetDistance( mViewingDistance );

	if( nFlags & MK_RBUTTON ) {
		if( nFlags & MK_CONTROL ) {
		} else if( nFlags & MK_SHIFT ) {
		} else {
			jammer.getCameraController().arcBallBeginRotate( x, y );
		}
		mPrevMousePoint = point;
	}

	updateUIFromMouseActions();
}

void CJammerView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CFormView::OnMouseMove(nFlags, point);

	mLMouseUp = (nFlags & MK_LBUTTON);

	float x, y;
	if( !pixelsToScreen( point.x, point.y, x, y ) )
		return;

	CJammer& jammer = *getDocument().getJammer();
	jammer.setPicker( x, y );
	jammer.getCameraController().arcBallSetDistance( mViewingDistance );

	if( nFlags & MK_RBUTTON ) {
		float prevX, prevY;
		pixelsToScreen( mPrevMousePoint.x, mPrevMousePoint.y, prevX, prevY );
		if( nFlags & MK_CONTROL ) {
			jammer.getCameraController().arcBallTranslate( -(x-prevX)*mViewingDistance, (y-prevY)*mViewingDistance, 0 );
		} else if( nFlags & MK_SHIFT ) {
			float zoom = (y-prevY) * 50.0f;
			mViewingDistance -= zoom;
			jammer.getCameraController().arcBallTranslate( 0, 0, zoom );
		} else {
			jammer.getCameraController().arcBallRotate( x, y );
		}
	}

	if( nFlags & MK_LBUTTON ) {
		if( !IsDlgButtonChecked(IDC_BTN_STATIC_ADD) && !IsDlgButtonChecked(IDC_BTN_THING_ADD) ) {
			CJammerStaticEntity* entity = jammer.getSelectedStatic();
			if( jammer.getEditMode() == MODE_CREATE && entity != NULL ) {
				float prevX, prevY;
				pixelsToScreen( mPrevMousePoint.x, mPrevMousePoint.y, prevX, prevY );
				entity->getMatrix().getOrigin() += jammer.getCamera().getWorldMatrix().getAxisX()* ((x-prevX)*mViewingDistance);
				entity->getMatrix().getOrigin() += jammer.getCamera().getWorldMatrix().getAxisY()* (-(y-prevY)*mViewingDistance);
				jammer.incLinkFrameCounter();
				jammer.moveStaticEntity( *entity );
			}
		}
	}

	mPrevMousePoint = point;
	updateUIFromMouseActions();
}

void CJammerView::updateUIFromMouseActions()
{
	CJammer& jammer = *getDocument().getJammer();

	//
	// selection text
	if( jammer.getSelectedTag() != NULL ) {
		CTagInstance const* tag = jammer.getSelectedTag();
		char buf[200];
		sprintf( buf, "Tag %s [%s]", tag->getTag().getName().c_str(), ((CStaticEntity*)tag->getOwner())->getName().c_str() );
		mStaticSelection.SetWindowText( buf );
	} else if( jammer.getSelectedStatic() != NULL ) {
		CJammerStaticEntity const* e = jammer.getSelectedStatic();
		char buf[200];
		sprintf( buf, "Static %s [%s]", e->getName().c_str(), e->getClass().getName().c_str() );
		mStaticSelection.SetWindowText( buf );
	} else if( jammer.getSelectedThing() != NULL ) {
		CJammerThingEntity const* e = jammer.getSelectedThing();
		char buf[200];
		sprintf( buf, "Thing %s [%s]", e->getName().c_str(), e->getClass().getName().c_str() );
		mStaticSelection.SetWindowText( buf );
	} else {
		mStaticSelection.SetWindowText("");
	}

	//
	// link
	if( jammer.getEditMode() == MODE_LINK ) {
		if( jammer.getSelectedTagForLink() != NULL ) {
			CTagInstance const* tag = jammer.getSelectedTagForLink();
			char buf[200];
			if( tag->isLinked() ) {
				sprintf( buf, "Tag %s; linked", tag->getTag().getName().c_str() );
				mStaticLinkInstr.SetWindowText( "" );
			} else {
				sprintf( buf, "Link %s...", tag->getTag().getName().c_str() );
				mStaticLinkInstr.SetWindowText( "Click on tag to end link" );
			}
			mStaticLinkSel.SetWindowText( buf );
		} else {
			mStaticLinkSel.SetWindowText( "" );
			mStaticLinkInstr.SetWindowText( "Click on tag to begin link" );
		}
	} else{
		mStaticLinkInstr.SetWindowText( "" );
	}
	redraw();
}

void CJammerView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CFormView::OnLButtonDown(nFlags, point);
	float x, y;
	if( !pixelsToScreen( point.x, point.y, x, y ) )
		return;
	CJammer& jammer = *getDocument().getJammer();
	jammer.setPicker( x, y );

	if( mLMouseUp ) {
		if( !IsDlgButtonChecked(IDC_BTN_STATIC_ADD) && !IsDlgButtonChecked(IDC_BTN_THING_ADD) )
			jammer.select();
	}

	mLMouseUp = false;
	
	updateUIFromMouseActions();
}

void CJammerView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	mLMouseUp = true;
	CFormView::OnLButtonUp(nFlags, point);
	float x, y;
	if( !pixelsToScreen( point.x, point.y, x, y ) )
		return;
	CJammer& jammer = *getDocument().getJammer();
	jammer.setPicker( x, y );

	jammer.select();

	if( jammer.getEditMode()==MODE_CREATE && IsDlgButtonChecked(IDC_BTN_STATIC_ADD) ) {
		char buf[200];
		mComboStatics.GetLBText( mComboStatics.GetCurSel(), buf );
		jammer.addStaticEntity( buf );
	}
	if( jammer.getEditMode()==MODE_CREATE && IsDlgButtonChecked(IDC_BTN_THING_ADD) ) {
		char buf[200];
		mComboThings.GetLBText( mComboThings.GetCurSel(), buf );
		getDocument().getJammer()->addThingEntity( buf );
	}

	updateUIFromMouseActions();
}

void CJammerView::updateUIFromEditMode()
{
	CJammer& jammer = *getDocument().getJammer();
	
	// create mode stuff
	bool createEnabled = jammer.getEditMode() == MODE_CREATE;
	mComboStatics.EnableWindow( createEnabled );
	GetDlgItem(IDC_BTN_STATIC_ADD)->EnableWindow( createEnabled );
	mComboThings.EnableWindow( createEnabled );
	GetDlgItem(IDC_BTN_THING_ADD)->EnableWindow( createEnabled );

	CheckDlgButton(IDC_BTN_STATIC_ADD, BST_UNCHECKED);
	CheckDlgButton(IDC_BTN_THING_ADD, BST_UNCHECKED);

	// link mode stuff
	bool linkEnabled = jammer.getEditMode() == MODE_LINK;
	mStaticLinkSel.SetWindowText( "" );
	mStaticLinkInstr.SetWindowText( linkEnabled ? "Click on tag to begin link" : "" );
	jammer.getJamLevel().getVisTags().setVisible( linkEnabled );
}



// --------------------------------------------------------------------------
//  menu/toolbar handlers
// --------------------------------------------------------------------------


// --------------------------------------------------------------------------
//  edit menu

void CJammerView::OnEditCreatemode() 
{
	CJammer& jammer = *getDocument().getJammer();
	jammer.setEditMode( MODE_CREATE );
	updateUIFromEditMode();
	mStaticEditmode.SetWindowText("Create");
}
void CJammerView::OnUpdateEditCreatemode(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( getDocument().getJammer()->getEditMode() == MODE_CREATE );
}


void CJammerView::OnEditLinkmode() 
{
	CJammer& jammer = *getDocument().getJammer();
	jammer.setEditMode( MODE_LINK );
	updateUIFromEditMode();
	mStaticEditmode.SetWindowText("Link");
}
void CJammerView::OnUpdateEditLinkmode(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck( getDocument().getJammer()->getEditMode() == MODE_LINK );
}

void CJammerView::OnEditRename() 
{
	CJammer& jammer = *getDocument().getJammer();
	if( jammer.getEditMode() == MODE_CREATE ) {
		CBaseEntity* es = jammer.getSelectedStatic();
		if( es != NULL ) {
			CNameDialog dlg;
			dlg.setName( es->getName() );
			dlg.DoModal();
			std::string newName = dlg.getName();
			if( es->getName() != newName ) {
				CGameInfo::getInstance().getLevel().getStaticEntities().renameEntity( es, newName );
				redraw();
			}
		}
		CBaseEntity* et = jammer.getSelectedThing();
		if( et != NULL ) {
			CNameDialog dlg;
			dlg.setName( et->getName() );
			dlg.DoModal();
			std::string newName = dlg.getName();
			if( et->getName() != newName ) {
				CGameInfo::getInstance().getLevel().getThingEntities().renameEntity( et, newName );
				redraw();
			}
		}
	}
}

void CJammerView::OnUpdateEditRename(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerStaticEntity* es = jammer.getSelectedStatic();
	CJammerThingEntity* et = jammer.getSelectedThing();
	bool ok = jammer.getEditMode()==MODE_CREATE && (es!=NULL || et!=NULL);
	pCmdUI->Enable( ok );
}


// --------------------------------------------------------------------------
//  link menu


void CJammerView::OnLinkFlipx() 
{
	getDocument().getJammer()->flipStaticLink( SVector3(-1,1,1) );
	redraw();
}
void CJammerView::OnUpdateLinkFlipx(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	bool ok = jammer.getEditMode()==MODE_LINK && tag!=NULL && tag->isLinked();
	pCmdUI->Enable( ok );
	pCmdUI->SetCheck( ok ? (tag->getFlips().x<0) : 0 );
}

void CJammerView::OnLinkFlipy() 
{
	getDocument().getJammer()->flipStaticLink( SVector3(1,-1,1) );
	redraw();
}
void CJammerView::OnUpdateLinkFlipy(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	bool ok = jammer.getEditMode()==MODE_LINK && tag!=NULL && tag->isLinked();
	pCmdUI->Enable( ok );
	pCmdUI->SetCheck( ok ? (tag->getFlips().y<0) : 0 );
}
void CJammerView::OnLinkFlipz() 
{
	getDocument().getJammer()->flipStaticLink( SVector3(1,1,-1) );
	redraw();
}
void CJammerView::OnUpdateLinkFlipz(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	bool ok = jammer.getEditMode()==MODE_LINK && tag!=NULL && tag->isLinked();
	pCmdUI->Enable( ok );
	pCmdUI->SetCheck( ok ? (tag->getFlips().z<0) : 0 );
}

void CJammerView::OnLinkOther() 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	if( tag!=NULL && tag->isLinked() ) {
		jammer.setSelectedTagForLink( (CJammerTagInstance*)tag->getLink() );
	}
	redraw();
}
void CJammerView::OnUpdateLinkOther(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	bool ok = jammer.getEditMode()==MODE_LINK && tag!=NULL && tag->isLinked();
	pCmdUI->Enable( ok );
}
void CJammerView::OnLinkUnlink() 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	if( tag!=NULL && tag->isLinked() ) {
		// unlink both tags
		tag->getLink()->setLink( NULL );
		tag->setLink( NULL );
	}
	redraw();
}
void CJammerView::OnUpdateLinkUnlink(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CTagInstance* tag = jammer.getSelectedTagForLink();
	bool ok = jammer.getEditMode()==MODE_LINK && tag!=NULL && tag->isLinked();
	pCmdUI->Enable( ok );
}

// --------------------------------------------------------------------------
//  create menu


void CJammerView::OnCreateDelete() 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerStaticEntity* es = jammer.getSelectedStatic();
	if( jammer.getEditMode()==MODE_CREATE && es!=NULL ) {
		jammer.removeStaticEntity( *es );
	}
	CJammerThingEntity* et = jammer.getSelectedThing();
	if( jammer.getEditMode()==MODE_CREATE && et!=NULL ) {
		jammer.removeThingEntity( *et );
	}
	redraw();
}
void CJammerView::OnUpdateCreateDelete(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerStaticEntity* es = jammer.getSelectedStatic();
	CJammerThingEntity* et = jammer.getSelectedThing();
	bool ok = jammer.getEditMode()==MODE_CREATE && (es!=NULL || et!=NULL);
	pCmdUI->Enable( ok );
}

void CJammerView::OnCreateTurnleft() 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerThingEntity* et = jammer.getSelectedThing();
	if( jammer.getEditMode()==MODE_CREATE && et!=NULL ) {
		SMatrix4x4 m;
		D3DXMatrixRotationY( &m, 3.1415927f / 180.0f * 10.0f );
		et->getMatrix() = m * et->getMatrix();
		redraw();
	}
}
void CJammerView::OnUpdateCreateTurnleft(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerThingEntity* et = jammer.getSelectedThing();
	bool ok = jammer.getEditMode()==MODE_CREATE && et!=NULL;
	pCmdUI->Enable( ok );
}

void CJammerView::OnCreateTurnright() 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerThingEntity* et = jammer.getSelectedThing();
	if( jammer.getEditMode()==MODE_CREATE && et!=NULL ) {
		SMatrix4x4 m;
		D3DXMatrixRotationY( &m, -3.1415927f / 180.0f * 10.0f );
		et->getMatrix() = m * et->getMatrix();
		redraw();
	}
}
void CJammerView::OnUpdateCreateTurnright(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	CJammerThingEntity* et = jammer.getSelectedThing();
	bool ok = jammer.getEditMode()==MODE_CREATE && et!=NULL;
	pCmdUI->Enable( ok );
}


// --------------------------------------------------------------------------
//  view menu


void CJammerView::OnViewFocus() 
{
	CJammer& jammer = *getDocument().getJammer();
	// get focus entity
	CJammerStaticEntity* focusEntity = NULL;
	if( jammer.getEditMode()==MODE_CREATE && jammer.getSelectedStatic()!=NULL ) {
		focusEntity = jammer.getSelectedStatic();
	} else if( jammer.getEditMode()==MODE_LINK && jammer.getSelectedTagForLink()!=NULL ) {
		focusEntity = (CJammerStaticEntity*)jammer.getSelectedTagForLink()->getOwner();
	}
	// focus on it
	if( focusEntity ) {
		SMatrix4x4& camMat = jammer.getCamera().getMatrix();
		SLine3 viewLine;
		viewLine.pos = camMat.getOrigin();
		viewLine.vec = camMat.getAxisZ();
		SMatrix4x4 const& eMat = focusEntity->getMatrix();
		SVector3 projOnLine = viewLine.interpolate( viewLine.project( eMat.getOrigin() ) );
		camMat.getOrigin() += eMat.getOrigin() - projOnLine;
		mViewingDistance = SVector3(camMat.getOrigin()-eMat.getOrigin()).length();
		redraw();
	}
}

void CJammerView::OnUpdateViewFocus(CCmdUI* pCmdUI) 
{
	CJammer& jammer = *getDocument().getJammer();
	bool ok = false;
	if( jammer.getEditMode()==MODE_CREATE && jammer.getSelectedStatic()!=NULL )
		ok = true;
	else if( jammer.getEditMode()==MODE_LINK && jammer.getSelectedTagForLink()!=NULL )
		ok = true;
	pCmdUI->Enable( ok );
}
