#ifndef __JAMMER_VIEW_H
#define __JAMMER_VIEW_H

#include "JammerDoc.h"

// --------------------------------------------------------------------------

class CJammerView : public CFormView {
public:
	CJammerDoc const& getDocument() const { return *(CJammerDoc const*)m_pDocument; };
	CJammerDoc& getDocument() { return *(CJammerDoc*)m_pDocument; };

private:
	bool	pixelsToScreen( int px, int py, float& x, float& y ) const;
	void	initScannedStuff();
	void	redraw();
	void	updateUIFromMouseActions();
	void	updateUIFromEditMode();

private:
	CPoint	mPrevMousePoint;
	bool	mLMouseUp;
	float	mViewingDistance;

protected: // create from serialization only
	CJammerView();
	DECLARE_DYNCREATE(CJammerView)
public:
	//{{AFX_DATA(CJammerView)
	enum { IDD = IDD_JAMMER_FORM };
	CComboBox	mComboThings;
	CStatic	mStaticEditmode;
	CStatic	mStaticSelection;
	CStatic	mStaticLinkSel;
	CStatic	mStaticLinkInstr;
	CComboBox	mComboStatics;
	CStatic	mRenderArea;
	//}}AFX_DATA
public:
	//{{AFX_VIRTUAL(CJammerView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct
	virtual void OnDraw(CDC* pDC);
	//}}AFX_VIRTUAL
public:
	virtual ~CJammerView();

protected:
	//{{AFX_MSG(CJammerView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBtnStaticAdd();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnEditCreatemode();
	afx_msg void OnEditLinkmode();
	afx_msg void OnUpdateEditCreatemode(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditLinkmode(CCmdUI* pCmdUI);
	afx_msg void OnLinkFlipx();
	afx_msg void OnUpdateLinkFlipx(CCmdUI* pCmdUI);
	afx_msg void OnLinkFlipy();
	afx_msg void OnUpdateLinkFlipy(CCmdUI* pCmdUI);
	afx_msg void OnLinkFlipz();
	afx_msg void OnUpdateLinkFlipz(CCmdUI* pCmdUI);
	afx_msg void OnLinkOther();
	afx_msg void OnUpdateLinkOther(CCmdUI* pCmdUI);
	afx_msg void OnLinkUnlink();
	afx_msg void OnUpdateLinkUnlink(CCmdUI* pCmdUI);
	afx_msg void OnCreateDelete();
	afx_msg void OnUpdateCreateDelete(CCmdUI* pCmdUI);
	afx_msg void OnViewFocus();
	afx_msg void OnUpdateViewFocus(CCmdUI* pCmdUI);
	afx_msg void OnBtnThingAdd();
	afx_msg void OnCreateTurnleft();
	afx_msg void OnUpdateCreateTurnleft(CCmdUI* pCmdUI);
	afx_msg void OnCreateTurnright();
	afx_msg void OnUpdateCreateTurnright(CCmdUI* pCmdUI);
	afx_msg void OnEditRename();
	afx_msg void OnUpdateEditRename(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


//{{AFX_INSERT_LOCATION}}

#endif
