// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __ABSTRACT_COMPONENT_H
#define __ABSTRACT_COMPONENT_H


namespace unco {


class CAbstractComponent {
public:
	CAbstractComponent() : mAttached(false) { };
	virtual ~CAbstractComponent() { };

	/** Come to life :) */
	void	attach();
	/** Come to rest :) */
	void	detach();
	bool	isAttached() const { return mAttached; }

	// TBD: something is not very good here
	virtual void update() = 0;

protected:
	virtual void onAttach() = 0;
	virtual void onDetach() = 0;

private:
	// no copy
	CAbstractComponent( const CAbstractComponent& r );
	CAbstractComponent const& operator=( CAbstractComponent& r );

private:
	bool	mAttached;
};


}; // namespace


#endif
