// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "AbstractColComponent.h"
#include "../../kernel/Contexts.h"
#include <dingus/collider-ode/CollisionContext.h>

using namespace unco;


CAbstractColComponent::CAbstractColComponent( const dingus::SMatrix4x4& baseWorldMatrix, dingus::CCollidableContainer* container )
:	mCollidable( NULL ),
	mBaseWorldMatrix( &baseWorldMatrix ),
	mContainer( container )
{
	mMatrix.identify();
	mWorldMatrix.identify();
}

void CAbstractColComponent::onAttach()
{
	assert( mCollidable || !"set collidable from child class" );
	if( mContainer ) {
		mContainer->add( *mCollidable );
	} else {
		dingus::CCollisionContext& cctx = CContexts::getCollisionCtx();
		cctx.addCollidable( *mCollidable );
	}
}

void CAbstractColComponent::onDetach()
{
	assert( mCollidable || !"no collidable" );
	if( mContainer ) {
		mContainer->remove( *mCollidable );
	} else {
		dingus::CCollisionContext& cctx = CContexts::getCollisionCtx();
		cctx.removeCollidable( *mCollidable );
	}
}

void CAbstractColComponent::update()
{
	assert( mBaseWorldMatrix );
	mWorldMatrix = mMatrix * (*mBaseWorldMatrix);
	assert( mCollidable );
	mCollidable->setPosition( mWorldMatrix.getOrigin() );
	mCollidable->setRotation( mWorldMatrix );
}
