// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __ABSTRACT_COL_COMP_H
#define __ABSTRACT_COL_COMP_H

#include "../AbstractComponent.h"

#include <dingus/collider-ode/Collidable.h>


namespace unco {


/**
 *  Abstract collision component.
 *
 *  Represends one atomic CCollidable and maintains it attached as a child to
 *  something. Base parent world matrix is passed by ref in the constuctor (eg.
 *  this may be entity's world matrix). On each update, collidable's transform
 *  is calculated from the matrix in this component and base world matrix.
 *  This means that all the transforms set directly on the collidable will be lost
 *  on the next update, so set them to the component's matrix instead.
 *
 *  Attaches to collision context.
 */
class CAbstractColComponent : public CAbstractComponent {
public:
	CAbstractColComponent( const dingus::SMatrix4x4& baseWorldMatrix, dingus::CCollidableContainer* container = NULL );
		
	dingus::CCollidable const& getCollidable() const { return *mCollidable; }
	dingus::CCollidable& getCollidable() { return *mCollidable; }

	dingus::SMatrix4x4 const& getBaseWorldMatrix() const { return *mBaseWorldMatrix; }
	
	dingus::SMatrix4x4 const& getWorldMatrix() const { return mWorldMatrix; }
	dingus::SMatrix4x4 const& getMatrix() const { return mMatrix; }
	dingus::SMatrix4x4& getMatrix() { return mMatrix; }

	// CAbstractComponent
	virtual void update();

protected:

	/**
	 *  Collidable must already be set by a child class.
	 *  This will add the collidable to context.
	 */
	virtual void onAttach();

	/**
	 *  This will detach the collidable from the context.
	 */
	virtual void onDetach();

	void setCollidable( dingus::CCollidable& r ) { mCollidable = &r; }
	
private:
	dingus::SMatrix4x4			mMatrix;
	dingus::SMatrix4x4			mWorldMatrix;
	dingus::CCollidable*		mCollidable;
	dingus::CCollidableContainer*		mContainer;
	dingus::SMatrix4x4 const*	mBaseWorldMatrix;
};


}; // namespace

#endif
