// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "ColBoxComponent.h"

using namespace unco;


CColBoxComponent::CColBoxComponent( const dingus::SMatrix4x4& baseWorldMatrix, dingus::CCollidableContainer* container )
:	CAbstractColComponent( baseWorldMatrix, container )
{
	dingus::CCollidableBox* m = new dingus::CCollidableBox( NULL, dingus::SVector3(1,1,1) );
	setCollidable( *m );
}

CColBoxComponent::~CColBoxComponent()
{
	delete &getCollidable();
}

void CColBoxComponent::setSize( const dingus::SVector3& s )
{
	dingus::CCollidableBox& b = (dingus::CCollidableBox&)getCollidable();
	b.setLen(s);
}

dingus::SVector3 CColBoxComponent::getSize() const
{
	dingus::CCollidableBox& b = (dingus::CCollidableBox&)getCollidable();
	return b.getLen();
}

float CColBoxComponent::pointDepth( const dingus::SVector3& s ) const
{
	return dGeomBoxPointDepth( getCollidable(), s.x, s.y, s.z );
}
