// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __COL_BOX_COMPONENT_H
#define __COL_BOX_COMPONENT_H

#include "AbstractColComponent.h"

namespace unco {


/**
 *  Collidable box component.
 *
 *  Set box size via setSize(); initially all sizes are one. Point of reference
 *  for the box is it's center.
 */
class CColBoxComponent : public CAbstractColComponent {
public:
	CColBoxComponent( const dingus::SMatrix4x4& baseWorldMatrix, dingus::CCollidableContainer* container = NULL );
	virtual ~CColBoxComponent();

	void	setSize( const dingus::SVector3& s );
	dingus::SVector3 getSize() const;

	/**
	 *  Returns depth of given world space point in the box. Inside will
	 *  be positive, outside will be negative.
	 */
	float	pointDepth( const dingus::SVector3& s ) const;
};



}; // namespace

#endif
