// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "ColSphereComponent.h"

using namespace unco;


CColSphereComponent::CColSphereComponent( const dingus::SMatrix4x4& baseWorldMatrix, dingus::CCollidableContainer* container )
:	CAbstractColComponent( baseWorldMatrix, container )
{
	dingus::CCollidableSphere* m = new dingus::CCollidableSphere( NULL, 1 );
	setCollidable( *m );
}

CColSphereComponent::~CColSphereComponent()
{
	delete &getCollidable();
}

void CColSphereComponent::setRadius( float r )
{
	dingus::CCollidableSphere& b = (dingus::CCollidableSphere&)getCollidable();
	b.setRadius(r);
}

float CColSphereComponent::getRadius() const
{
	dingus::CCollidableSphere& b = (dingus::CCollidableSphere&)getCollidable();
	return b.getRadius();
}

float CColSphereComponent::pointDepth( const dingus::SVector3& s ) const
{
	return dGeomSpherePointDepth( getCollidable(), s.x, s.y, s.z );
}
