// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __COL_SPHERE_COMPONENT_H
#define __COL_SPHERE_COMPONENT_H

#include "AbstractColComponent.h"

namespace unco {


/**
 *  Collidable sphere component.
 *
 *  Set sphere radius via setRadius(); initially it's one. Point of reference
 *  for the sphere is it's center.
 */
class CColSphereComponent : public CAbstractColComponent {
public:
	CColSphereComponent( const dingus::SMatrix4x4& baseWorldMatrix, dingus::CCollidableContainer* container = NULL );
	virtual ~CColSphereComponent();

	void	setRadius( float r );
	float	getRadius() const;

	/**
	 *  Returns depth of given world space point in the sphere. Inside will
	 *  be positive, outside will be negative.
	 */
	float	pointDepth( const dingus::SVector3& s ) const;
};



}; // namespace

#endif
