// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "AbstractGfxComponent.h"
#include "ParamNames.h"
#include "../../kernel/Contexts.h"

using namespace unco;


CAbstractGfxComponent::CAbstractGfxComponent( dingus::CResourceId const& fxID, int renderLayer, const dingus::SMatrix4x4& worldMatrix )
:	mFxID( fxID ),
	mRenderLayer( renderLayer ),
	mRenderable( NULL ),
	mWorldMatrix( &worldMatrix )
{
	mParams.addMatrix4x4Ref( FX_PARAM_M_WORLD, *mWorldMatrix );
}

CAbstractGfxComponent::~CAbstractGfxComponent()
{
}

void CAbstractGfxComponent::onAttach()
{
	assert( mRenderable || !"set renderable from child class" );
	dingus::CRenderContext& rctx = CContexts::getRenderCtx();
	rctx.getLayer( mRenderLayer ).addRenderable( *mRenderable, mFxID );
	mRenderable->getParams() = mParams;
}

void CAbstractGfxComponent::onDetach()
{
	assert( mRenderable || !"no renderable" );
	dingus::CRenderContext& rctx = CContexts::getRenderCtx();
	rctx.getLayer( mRenderLayer ).removeRenderable( *mRenderable, mFxID );
	mRenderable->getParams().clear();
}

void CAbstractGfxComponent::onVisible( dingus::CVisibilityLeaf const& visSlot )
{
	assert( mRenderable || !"no renderable" );
	dingus::CRenderContext& rctx = CContexts::getRenderCtx();
	mRenderable->setActive( rctx );
}
