// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __ABSTRACT_GFX_COMP_H
#define __ABSTRACT_GFX_COMP_H

#include "../AbstractComponent.h"

#include <dingus/visibility/VisibilityLeaf.h>
#include <dingus/renderer/Renderable.h>


namespace unco {


/**
 *  Abstract graphical component.
 *
 *  By itself it's a IVisibilityListener, so you can add it to visibility context.
 *
 *  Attaches to render context.
 */
class CAbstractGfxComponent : public CAbstractComponent, public dingus::IVisibilityListener {
public:
	CAbstractGfxComponent( dingus::CResourceId const& fxID, int renderLayer, const dingus::SMatrix4x4& worldMatrix );
	virtual ~CAbstractGfxComponent();
		
	// IVisibilityListener
	virtual void onVisible( dingus::CVisibilityLeaf const& visSlot );

	dingus::CResourceId const& getFxID() const { return mFxID; }
	int getRenderLayer() const { return mRenderLayer; }

	dingus::CEffectParams const& getParams() const { return mParams; }
	dingus::CEffectParams& getParams() { return mParams; }
	dingus::CRenderable const& getRenderable() const { return *mRenderable; }

	dingus::SMatrix4x4 const& getWorldMatrix() const { return *mWorldMatrix; }
	
	// CAbstractComponent
	virtual void update() { };

protected:
	dingus::CRenderable& getRenderable() { return *mRenderable; }

	/**
	 *  The renderable must already be set by a child class.
	 *  This will add the renderable to render context.
	 */
	virtual void onAttach();

	/**
	 *  This will detach the renderable from the render context.
	 */
	virtual void onDetach();

	void setRenderable( dingus::CRenderable& r ) { mRenderable = &r; }
	
private:
	dingus::CEffectParams	mParams;
	dingus::CResourceId		mFxID;
	int						mRenderLayer;
	dingus::CRenderable*	mRenderable;
	dingus::SMatrix4x4 const* mWorldMatrix;
};


}; // namespace

#endif
