// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "BillboardsComponent.h"
#include "../../kernel/Contexts.h"

using namespace unco;


CBillboardsComponent::CBillboardsComponent( dingus::CD3DIndexBuffer& ib, dingus::CResourceId const& fxID, int renderLayer )
:	CAbstractGfxComponent( fxID, renderLayer, mMatrix )
{
	mBillboards = new dingus::CRenderableBillboards( ib, CContexts::getDynamicVBManager(), "tBase" );
	setRenderable( *mBillboards );
}

CBillboardsComponent::~CBillboardsComponent()
{
	delete &getRenderable();
}
