// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __BILL_COMPONENT_H
#define __BILL_COMPONENT_H

#include "AbstractGfxComponent.h"
#include <dingus/kernel/Proxies.h>
#include <dingus/gfx/RenderableBillboards.h>

namespace unco {



class CBillboardsComponent : public CAbstractGfxComponent {
public:
	CBillboardsComponent( dingus::CD3DIndexBuffer& ib, dingus::CResourceId const& fxID, int renderLayer );
	virtual ~CBillboardsComponent();

	dingus::CRenderableBillboards& getBillboards() { return *mBillboards; }
		
private:
	dingus::CRenderableBillboards*	mBillboards;
	dingus::SMatrix4x4				mMatrix;
};



}; // namespace

#endif
