// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __IB_COMPONENT_H
#define __IB_COMPONENT_H

#include "AbstractGfxComponent.h"
#include <dingus/renderer/RenderableBuffer.h>

namespace unco {



class CIndexedBufferComponent : public CAbstractGfxComponent {
public:
	CIndexedBufferComponent( dingus::CResourceId const& fxID, int renderLayer, const dingus::SMatrix4x4& worldMatrix );
	virtual ~CIndexedBufferComponent();

	dingus::CRenderableIndexedBuffer const& getIndexedBuffer() const { return *mIndexedBuffer; }
	dingus::CRenderableIndexedBuffer& getIndexedBuffer() { return *mIndexedBuffer; }
		
private:
	dingus::CRenderableIndexedBuffer*	mIndexedBuffer;
};



}; // namespace

#endif
