// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "KeyframeMeshComponent.h"

#include <dingus/gfx/VSKeyframeMeshRenderer.h>
#include "ParamNames.h"
#include "../../kernel/Contexts.h"

using namespace unco;


CKeyframeVS2MeshComponent::CKeyframeVS2MeshComponent( dingus::CD3DVertexDecl& vDecl, dingus::CResourceId const& fxID, int renderLayer, const dingus::SMatrix4x4& worldMatrix )
:	CAbstractGfxComponent( fxID, renderLayer, worldMatrix ),
	mVertexDecl( &vDecl ),
	mMesh0( NULL ), mMesh1( NULL ),
	mT( 0.0f ), mReady( false )
{
	mRenderableIBuffer = new dingus::CRenderableIndexedBuffer();
	setRenderable( *mRenderableIBuffer );
	mMeshRenderer = new dingus::CVSKeyframe2MeshRenderer( *mRenderableIBuffer, *mVertexDecl, FX_PARAM_F_BLEND );
	getParams().addMatrix4x4Ref( FX_PARAM_M_WVP, mWorldViewProj );
	getRenderable().addListener( *this );
}

CKeyframeVS2MeshComponent::~CKeyframeVS2MeshComponent()
{
	delete mRenderableIBuffer;
	delete mMeshRenderer;
}



void CKeyframeVS2MeshComponent::setKeyframe( dingus::CD3DXMesh& mesh0, dingus::CD3DXMesh& mesh1, float t )
{
	mMesh0 = &mesh0;
	mMesh1 = &mesh1;
	mT = t;
	mReady = true;
}


void CKeyframeVS2MeshComponent::beforeRender( dingus::CRenderable& r, dingus::CEffectSlot const& fx )
{
	if( !mReady )
		return;
	if( !isAttached() )
		return;

	// transposed world*view*projection matrix
	dingus::CRenderContext& rc = CContexts::getRenderCtx();
	D3DXMatrixMultiply( &mWorldViewProj, getWorldMatrix(), &rc.getCamera().getViewMatrix() );
	D3DXMatrixMultiply( &mWorldViewProj, &mWorldViewProj, &rc.getCamera().getProjectionMatrix() );

	mMeshRenderer->render( *mMesh0, *mMesh1, mT );
}
