// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __KEYFRAME_MESH_COMP_H
#define __KEYFRAME_MESH_COMP_H

#include "AbstractGfxComponent.h"
#include <dingus/kernel/Proxies.h>
#include <dingus/renderer/RenderableBuffer.h>


namespace dingus {
	class CVSKeyframe2MeshRenderer;
};


namespace unco {



class CKeyframeVS2MeshComponent : public CAbstractGfxComponent, public dingus::CRenderListenerAdapter {
public:
	CKeyframeVS2MeshComponent( dingus::CD3DVertexDecl& vDecl, dingus::CResourceId const& fxID, int renderLayer, const dingus::SMatrix4x4& worldMatrix );
	virtual ~CKeyframeVS2MeshComponent();
		
	void setKeyframe( dingus::CD3DXMesh& mesh0, dingus::CD3DXMesh& mesh1, float t );

	// CRenderListenerAdapter
	virtual void beforeRender( dingus::CRenderable& r, dingus::CEffectSlot const& fx );

private:
	dingus::CD3DVertexDecl*	mVertexDecl;
	dingus::CD3DXMesh*	mMesh0;
	dingus::CD3DXMesh*	mMesh1;
	float		mT;
	bool		mReady;

	dingus::CRenderableIndexedBuffer*	mRenderableIBuffer;
	dingus::CVSKeyframe2MeshRenderer*	mMeshRenderer;
	dingus::SMatrix4x4					mWorldViewProj;
};



}; // namespace


#endif
