// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "MeshComponent.h"
#include <dingus/renderer/RenderableMesh.h>

using namespace unco;


CMeshComponent::CMeshComponent( dingus::CD3DXMesh& mesh, int attrID, dingus::CResourceId const& fxID, int renderLayer, const dingus::SMatrix4x4& worldMatrix )
:	CAbstractGfxComponent( fxID, renderLayer, worldMatrix ),
	mMesh( &mesh ),
	mAttrID( attrID )
{
	dingus::CRenderableMesh* m = new dingus::CRenderableMesh( mAttrID, *mMesh );
	setRenderable( *m );
}

CMeshComponent::~CMeshComponent()
{
	delete &getRenderable();
}
