// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "PhysicsComponent.h"
#include "../../kernel/Contexts.h"
#include <dingus/physics-ode/PhysicsContext.h>

using namespace unco;


CPhysicsComponent::CPhysicsComponent( dingus::SMatrix4x4& controlledMatrix )
:	mPOROffset(0,0,0),
	mControlledMatrix( &controlledMatrix ),
	mPhysicsable( NULL )
{
	mMatrix.identify();
}

void CPhysicsComponent::onAttach()
{
	assert( !mPhysicsable );
	dingus::CPhysicsContext& cctx = CContexts::getPhysicsCtx();
	mPhysicsable = new dingus::CPhysicsable( cctx );
	mPhysicsable->setRotation( mMatrix );
	mPhysicsable->setPosition( mMatrix.getOrigin() );
}

void CPhysicsComponent::onDetach()
{
	assert( mPhysicsable || !"no physicsable" );
	delete mPhysicsable;
	mPhysicsable = NULL;
}

void CPhysicsComponent::setMatrixPORed( const dingus::SMatrix4x4& m )
{
	mMatrix = m;
	mMatrix.getOrigin() += m.getAxisX() * mPOROffset.x;
	mMatrix.getOrigin() += m.getAxisY() * mPOROffset.y;
	mMatrix.getOrigin() += m.getAxisZ() * mPOROffset.z;
	if( mPhysicsable ) {
		mPhysicsable->setRotation( m );
		mPhysicsable->setPosition( m.getOrigin() );
	}
	*mControlledMatrix = m;
}

void CPhysicsComponent::update()
{
	assert( mControlledMatrix );
	assert( mPhysicsable );
	mPhysicsable->getRotation( mMatrix );
	mMatrix.getOrigin() = mPhysicsable->getPosition();
	*mControlledMatrix = mMatrix;
	mControlledMatrix->getOrigin() -= mMatrix.getAxisX() * mPOROffset.x;
	mControlledMatrix->getOrigin() -= mMatrix.getAxisY() * mPOROffset.y;
	mControlledMatrix->getOrigin() -= mMatrix.getAxisZ() * mPOROffset.z;
}
