// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __PHYSICS_COMP_H
#define __PHYSICS_COMP_H

#include "../AbstractComponent.h"

#include <dingus/physics-ode/Physicsable.h>


namespace unco {


/**
 *  Physics component.
 *
 *  [TBD] doc
 *
 *  Attaches to physics context.
 */
class CPhysicsComponent : public CAbstractComponent {
public:
	CPhysicsComponent( dingus::SMatrix4x4& controlledMatrix );
	
	const dingus::SMatrix4x4& getMatrix() const { return mMatrix; }
	void setMatrixPORed( const dingus::SMatrix4x4& m );
	
	dingus::CPhysicsable const& getPhysicsable() const { return *mPhysicsable; }
	dingus::CPhysicsable& getPhysicsable() { return *mPhysicsable; }

	const dingus::SVector3& getPOROffset() const { return mPOROffset; }
	dingus::SVector3& getPOROffset() { return mPOROffset; }
	
	// CAbstractComponent
	virtual void update();

protected:
	/** This will add the physicsable to context. */
	virtual void onAttach();

	/** This will detach the physicsable from the context. */
	virtual void onDetach();

private:
	dingus::SMatrix4x4		mMatrix;
	dingus::SVector3		mPOROffset;
	dingus::SMatrix4x4*		mControlledMatrix;
	dingus::CPhysicsable*	mPhysicsable;
};


}; // namespace

#endif
