// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../../stdafx.h"
#pragma hdrstop

#include "VisibilityComponent.h"
#include "../../kernel/Contexts.h"

using namespace unco;



CAbstractVisComponent::CAbstractVisComponent( dingus::CVisibilityLeaf& visLeaf, dingus::CVisibilityContext::TVisDBID visDB )
:	mVisDB( visDB ),
	mVisLeaf( &visLeaf )
{
	assert( mVisLeaf || !"null vis leaf");
}

void CAbstractVisComponent::onAttach()
{
	mVisLeaf->addListener( mListeners );
	dingus::CVisibilityContext& vctx = CContexts::getVisCtx();
	vctx.getDB( mVisDB ).addLeaf( *mVisLeaf );
}

void CAbstractVisComponent::onDetach()
{
	dingus::CVisibilityContext& vctx = CContexts::getVisCtx();
	vctx.getDB( mVisDB ).removeLeaf( *mVisLeaf );
	mVisLeaf->removeListener( mListeners );
}
