// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VISIBILITY_COMP_H
#define __VISIBILITY_COMP_H

#include "../AbstractComponent.h"

#include <dingus/visibility/VisibilityContext.h>
#include <dingus/visibility/VisibilityLeaf.h>
#include <dingus/utils/AbstractNotifier.h>

namespace unco {


class CAbstractVisComponent : public CAbstractComponent {
public:
	CAbstractVisComponent( dingus::CVisibilityLeaf& visLeaf,
		dingus::CVisibilityContext::TVisDBID visDB = dingus::CVisibilityContext::DEFAULT_VIS_DB );
	virtual ~CAbstractVisComponent() { };

	void addListener( dingus::IVisibilityListener& listener ) { mListeners.addListener( listener ); }
	void removeListener( dingus::IVisibilityListener& listener ) { mListeners.removeListener( listener ); }
	
	dingus::CVisibilityLeaf const& getVisLeaf() const { return *mVisLeaf; }
	dingus::CVisibilityLeaf& getVisLeaf() { return *mVisLeaf; }
	dingus::CVisibilityContext::TVisDBID getVisDB() const { return mVisDB; }

	bool isVisible() const { return mListeners.mVisible; }
	void setVisible( bool v ) { mListeners.mVisible = v; }
	
protected:
	// CAbstractComponent
	virtual void update() { };
	virtual void onAttach();
	virtual void onDetach();

private:
	class CVisibilityNotifier : public dingus::CSimpleNotifier<dingus::IVisibilityListener>, public dingus::IVisibilityListener {
	public:
		CVisibilityNotifier() : mVisible( true ) { }
		// IVisibilityListener
		virtual void onVisible( dingus::CVisibilityLeaf const& visSlot ) {
			if( !mVisible )
				return;
			TListenerVector::iterator it, itEnd = getListeners().end();
			for( it = getListeners().begin(); it != itEnd; ++it ) {
				assert( *it );
				(*it)->onVisible( visSlot );
			}
		}
	public:
		bool	mVisible;
	};

private:
	dingus::CVisibilityLeaf*				mVisLeaf;
	dingus::CVisibilityContext::TVisDBID	mVisDB;
	CVisibilityNotifier						mListeners;
};



class CVisibilityComponent : public CAbstractVisComponent {
public:
	CVisibilityComponent( dingus::CVisibilityContext::TVisDBID visDB = dingus::CVisibilityContext::DEFAULT_VIS_DB )
		: CAbstractVisComponent( mVisLeaf, visDB ) { }
	virtual ~CVisibilityComponent() { };

private:
	dingus::CVisibilityLeaf	mVisLeaf;
};



}; // namespace

#endif
