// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop
 
#include "Camera.h"
#include <dingus/portal/PortalContext.h>
#include <dingus/renderer/RenderContext.h>
#include "../kernel/Contexts.h"

using namespace unco;


CCamera::CCamera( CRenderTarget& renderTarget, dingus::CVisibilityContext::TVisDBID visDB )
:	mRenderTarget( &renderTarget ),
	mVisDB( visDB )
{
	mPortal.addListener( *this );
}

void CCamera::internalAttach()
{
	dingus::CPortalContext& portalCtx = CContexts::getPortalCtx();
	portalCtx.addPortal( mPortal );
}

void CCamera::internalDetach()
{
	dingus::CPortalContext& portalCtx = CContexts::getPortalCtx();
	portalCtx.removePortal( mPortal );

	// just to be sure
	if( mPortal.isInside() )
		mRenderTarget->deactivate();
}

void CCamera::setProjectionParams( float fov, float aspect, float znear, float zfar )
{
	D3DXMatrixPerspectiveFovLH( &mProjectionMatrix, fov, aspect, znear, zfar );
	mFOV = fov;
	mZNear = znear;
	mZFar = zfar;
	mViewHalfWidth = 1.0f / mProjectionMatrix._11;
	mViewHalfHeight = 1.0f / mProjectionMatrix._22;
}

void CCamera::onBeforePortal( dingus::CPortal const& portal )
{
	dingus::CVisibilityContext& visCtx = CContexts::getVisCtx();
	visCtx.setActiveDB( mVisDB );
	dingus::CRenderContext& renderCtx = CContexts::getRenderCtx();
	renderCtx.getCamera().setCameraMatrix( getWorldMatrix() );
	renderCtx.getCamera().setProjectionMatrix( mProjectionMatrix );

	mRenderTarget->activate();
}

void CCamera::onAfterPortal( dingus::CPortal const& portal )
{
	mRenderTarget->deactivate();
	// TBD: should switch to previous visibility DB, to be more robust
}

dingus::SVector3 CCamera::getWorldRay( float x, float y ) const
{
	dingus::SMatrix4x4 m = getWorldMatrix();
	m.getOrigin().set(0,0,0);
	dingus::SVector3 r = getCameraRay( x, y );
	D3DXVec3TransformCoord( &r, &r, &m );
	return r;
}

dingus::SVector3 CCamera::getCameraRay( float x, float y ) const
{
	return dingus::SVector3( x*mViewHalfWidth, -y*mViewHalfHeight, 1.0f );
}
