// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __CAMERA_H
#define __CAMERA_H

#include "Entity.h"
#include "../helpers/RenderTarget.h"
#include <dingus/portal/Portal.h>
#include <dingus/visibility/VisibilityContext.h>
#include <dingus/math/Matrix4x4.h>

namespace dingus {
	class CPortalContext;
	class CRenderContext;
	class CRenderTarget;
};


namespace unco {


class CCamera : public CEntity, public dingus::IPortalListener {
public:
	CCamera( CRenderTarget& renderTarget, dingus::CVisibilityContext::TVisDBID visDB = dingus::CVisibilityContext::DEFAULT_VIS_DB );

	/** Activates camera for one frame only. */
	/*virtual*/void activate() { mPortal.activate(); }

	void	setProjectionParams( float fov, float aspect, float znear, float zfar );
	//void	setProjectionMatrix( dingus::SMatrix4x4 const& matrix ) { mProjectionMatrix = matrix; }
	dingus::SMatrix4x4 const& getProjectionMatrix() const { return mProjectionMatrix; }
	//dingus::SMatrix4x4& getProjectionMatrix() { return mProjectionMatrix; }

	/**
	 *  Gets world space ray from camera's viewing plane coordinates.
	 *  @param x X coordinate (-1 at left, 1 at right).
	 *  @param y Y coordinate (-1 at top, 1 at bottom).
	 *  @return Ray in world space (NOT unit length).
	 */
	dingus::SVector3 getWorldRay( float x, float y ) const;
	/**
	 *  Gets camera space ray from camera's viewing plane coordinates.
	 *  @param x X coordinate (-1 at left, 1 at right).
	 *  @param y Y coordinate (-1 at top, 1 at bottom).
	 *  @return Ray in camera space (NOT unit length).
	 */
	dingus::SVector3 getCameraRay( float x, float y ) const;

	CRenderTarget const& getRenderTarget() const { return *mRenderTarget; }
	CRenderTarget& getRenderTarget() { return *mRenderTarget; }

	// IPortalListener
	virtual void onBeforePortal( dingus::CPortal const& portal );
	virtual void onAfterPortal( dingus::CPortal const& portal );
	
protected:
	// CEntity
	virtual void internalAttach();
	virtual void internalDetach();
	
private:
	dingus::SMatrix4x4	mProjectionMatrix;
	
	float		mFOV;
	float		mZNear;
	float		mZFar;
	float		mViewHalfWidth; // at distance 1
	float		mViewHalfHeight; // at distance 1

	dingus::CPortal		mPortal;
	CRenderTarget*		mRenderTarget;
	dingus::CVisibilityContext::TVisDBID	mVisDB;
};


}; // namespace

#endif
