// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop


#include "Entity.h"
#include "../component/AbstractComponent.h"


using namespace unco;


CEntity::CEntity()
:	mContainer( NULL ), mParent( NULL ), mAttached( false ), mDiscarded( false )
{
	mMatrix.identify();
	mWorldMatrix.identify();
}

CEntity::~CEntity()
{
	dingus::stl_utils::wipe( mComponents );
}


void CEntity::update()
{
	// calc world matrix
	if( hasParent() ) {
		mWorldMatrix = mMatrix * getParent().getWorldMatrix();
	} else {
		mWorldMatrix = mMatrix;
	}

	// update components - if attached
	if( mAttached ) {
		TComponentVector::iterator it, itEnd = mComponents.end();
		for( it = mComponents.begin(); it != itEnd; ++it ) {
			assert( *it );
			(*it)->update();
		}
	}

	// internal update
	internalUpdate();
}


void CEntity::addComponent( CAbstractComponent& comp )
{
	mComponents.push_back( &comp );
}
void CEntity::addComponentFront( CAbstractComponent& comp )
{
	mComponents.insert( mComponents.begin(), &comp );
}

void CEntity::removeComponent( CAbstractComponent& comp )
{
	mComponents.remove( &comp );
}


void CEntity::attach()
{
	if( mAttached ) return;
	//assert( !mAttached || !"already attached" );
	mAttached = true;

	// attach components
	TComponentVector::iterator it, itEnd = mComponents.end();
	for( it = mComponents.begin(); it != itEnd; ++it ) {
		assert( *it );
		(*it)->attach();
	}

	internalAttach();
}

void CEntity::detach()
{
	assert( mAttached || !"not attached" );
	internalDetach();

	// detach components
	TComponentVector::iterator it, itEnd = mComponents.end();
	for( it = mComponents.begin(); it != itEnd; ++it ) {
		assert( *it );
		(*it)->detach();
	}

	mAttached = false;
}
