// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __ENTITY_H
#define __ENTITY_H

#include <dingus/math/Transform.h>
#include <dingus/utils/RefCounted.h>
#include "../component/AbstractComponent.h"

namespace unco {



class CEntity : public dingus::CRefCounted {
protected:
	typedef dingus::fastvector<CAbstractComponent*> TComponentVector;

public:
	CEntity();
	virtual ~CEntity();

	virtual void update();

	virtual void attach();
	virtual void detach();
	bool	isAttached() const { return mAttached; }

	void	discard() { mDiscarded = true; }
	bool	isDiscarded() const { return mDiscarded; }

	void	addComponent( CAbstractComponent& comp );
	// kind of HACK
	void	addComponentFront( CAbstractComponent& comp );
	void	removeComponent( CAbstractComponent& comp );
	TComponentVector const& getComponents() const { return mComponents; }
	TComponentVector& getComponents() { return mComponents; }

	void setContainer( CEntity* cont ) { mContainer = cont; }
	CEntity const& getContainer() const { return *mContainer; }
	CEntity& getContainer() { return *mContainer; }
	bool hasContainer() const { return (mContainer != 0); }

	void setParent( CEntity* parent ) { mParent = parent; }
	CEntity const& getParent() const { return *mParent; }
	CEntity& getParent() { return *mParent; }
	bool hasParent() const { return (mParent != 0); }

	dingus::SMatrix4x4 const& getMatrix() const { return mMatrix; }
	dingus::SMatrix4x4& getMatrix() { return mMatrix; }
	
	dingus::SMatrix4x4 const& getWorldMatrix() const { return mWorldMatrix; }
	dingus::SMatrix4x4& getWorldMatrix() { return mWorldMatrix; }
	
protected:
	virtual void internalUpdate() { };
	virtual void internalAttach() { };
	virtual void internalDetach() { };

private:
	dingus::SMatrix4x4	mMatrix;
	dingus::SMatrix4x4	mWorldMatrix;
	TComponentVector	mComponents;
	/** Container i'm contained in. */
	CEntity*	mContainer;
	/** Parent in transform hierarchy. Usually the same as container. */
	CEntity*	mParent;
	bool		mAttached;
	bool		mDiscarded;
};


typedef boost::intrusive_ptr<CEntity>	TEntityPtr;


}; // namespace


IMPLEMENT_INTRUSIVE_PTR(unco::CEntity);

#endif
