
#ifndef __NAMED_ENTITY_H
#define __NAMED_ENTITY_H

#include "Entity.h"

namespace unco {


class CNamedEntity : public CEntity {
public:
	CNamedEntity( const std::string& name ) : CEntity(), mName(name) { };

	const std::string& getName() const { return mName; }

	/**
	 *  Renames an entity. Use with great care, as entity name may serve
	 *  as a key to some container.
	 */
	void setName( const std::string& name ) { mName = name; }

private:
	std::string		mName;
};


}; // namespace

#endif
