// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __TYPED_CONTAINER_H
#define __TYPED_CONTAINER_H

#include "Entity.h"


namespace unco {


template<typename T>
class CTypedContainer : public CEntity {
public:
	typedef boost::intrusive_ptr<T>			TEntityPtr;
	typedef dingus::fastvector<TEntityPtr>	TEntityVector;
	
public:
	CTypedContainer() { };
	virtual ~CTypedContainer() { };

	virtual void update();
	virtual void attach();
	virtual void detach();
	
	void	addEntity( const TEntityPtr& entity );
	void	removeEntity( const TEntityPtr& entity );

	TEntityVector const& getEntities() const { return mEntities; }
	TEntityVector& getEntities() { return mEntities; }

protected:
	virtual void internalPostAttach() { }
	virtual void internalPreDetach() { }

private:
	TEntityVector	mEntities;
};


template<typename T>
void CTypedContainer<T>::addEntity( const TEntityPtr& entity )
{
	assert( !entity->hasContainer() || !"already has container" );
	mEntities.push_back( entity );
	entity->setContainer( this );
}

template<typename T>
void CTypedContainer<T>::removeEntity( const TEntityPtr& entity )
{
	assert( entity->hasContainer() || !"no container" );
	assert( &entity->getContainer() == this || !"not in this container" );

	mEntities.remove( entity );
	entity->setContainer( NULL );
}

template<typename T>
void CTypedContainer<T>::update()
{
	// update
	CEntity::update();

	// update children
	TEntityVector::iterator it, itEnd = mEntities.end();
	for( it = mEntities.begin(); it != itEnd; /* */ ) {
		TEntityPtr& e = *it;
		assert( e );
		if( e->isDiscarded() ) {
			it = mEntities.erase( it );
			itEnd = mEntities.end();
		} else {
			e->update();
			++it;
		}
	}
}

template<typename T>
void CTypedContainer<T>::attach()
{
	// attach self
	CEntity::attach();

	// attach children
	TEntityVector::iterator it, itEnd = mEntities.end();
	for( it = mEntities.begin(); it != mEntities.end(); ++it ) {
		assert( *it );
		(*it)->attach();
	}

	// final post attach
	internalPostAttach();
}

template<typename T>
void CTypedContainer<T>::detach()
{
	// pre detach
	internalPreDetach();

	// detach children
	TEntityVector::iterator it, itEnd = mEntities.end();
	for( it = mEntities.begin(); it != mEntities.end(); ++it ) {
		assert( *it );
		(*it)->detach();
	}

	// detach self
	CEntity::detach();
}


};

#endif
