// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "VSStencilLight.h"
#include <dingus/portal/PortalContext.h>
#include <dingus/visibility/VisibilityContext.h>
#include <dingus/renderer/RenderContext.h>
#include <dingus/kernel/D3DDevice.h>
#include "../kernel/Contexts.h"

using namespace unco;
//const CEffectParams::TParamName CVSStencilLight::EFX_PARAM_vLP0 = "vLP0";

CVSStencilLight::CVSStencilLight()
{
	mVisComp = new CVisibilityComponent( dingus::CVisibilityContext::DB_SHADOW_CASTER );
	mShadowPass = new CInternalLightPass( dingus::CVisibilityContext::DB_SHADOW_CASTER, true, getWorldMatrix() );
	mLightPass = new CInternalLightPass( dingus::CVisibilityContext::DB_SHADOW_RECEIVER, false, getWorldMatrix() );
	addComponent( *mVisComp );
	addComponent( *mShadowPass );
	addComponent( *mLightPass );
	mVisComp->addListener( *mLightPass );
}

CVSStencilLight::~CVSStencilLight()
{
}

void CVSStencilLight::onVisible( const dingus::CVisibilityLeaf& slot )
{
	mShadowPass->onVisible( slot );
}

CVSStencilLight::CInternalLightPass::CInternalLightPass( dingus::CVisibilityContext::TVisDBID visDB, bool toClear, const dingus::SMatrix4x4& worldMatrix )
:	mVisDB( visDB ),
	mWorldMatrix( &worldMatrix ),
	mToClear( toClear )
{
	mPortal.addListener( *this );
}

void CVSStencilLight::CInternalLightPass::onAttach()
{
	dingus::CPortalContext& pctx = CContexts::getPortalCtx();
	pctx.addPortal( mPortal );

	dingus::CRenderContext& rctx = CContexts::getRenderCtx();
	rctx.getGlobalParams().addVector3Ref( "vLightPos", mWorldMatrix->getOrigin() );
}

void CVSStencilLight::CInternalLightPass::onDetach()
{
	dingus::CPortalContext& pctx = CContexts::getPortalCtx();
	pctx.removePortal( mPortal );

	dingus::CRenderContext& rctx = CContexts::getRenderCtx();
	rctx.getGlobalParams().removeRef( "vLightPos" );
}

void CVSStencilLight::CInternalLightPass::onBeforePortal( const dingus::CPortal& portal )
{
	if( mToClear ) {
		// Clear the stencil buffer (leave frame- and z- intact)
		dingus::gD3DDevice->Clear( 0L, NULL, D3DCLEAR_STENCIL, 0L, 1.0f, 0L );
	}
	CContexts::getVisCtx().setActiveDB( mVisDB );
}

void CVSStencilLight::CInternalLightPass::onAfterPortal( const dingus::CPortal& portal )
{
	// TBD: must switch visibility to previous DB
}

void CVSStencilLight::CInternalLightPass::onVisible( const dingus::CVisibilityLeaf& slot )
{
	mPortal.activate();
}
