// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VS_STENCIL_LIGHT_H
#define __VS_STENCIL_LIGHT_H

#include <dingus/portal/Portal.h>
#include <dingus/math/Matrix4x4.h>
#include <dingus/visibility/VisibilityLeaf.h>
#include "Entity.h"
#include "../component/AbstractComponent.h"
#include "../component/vis/VisibilityComponent.h"

namespace dingus {
class CPortalContext;
};


namespace unco {


class CVSStencilLight : public CEntity, public dingus::IVisibilityListener {
public:
	//static const CEffectParams::TParamName EFX_PARAM_vLP0;
public:
	CVSStencilLight();
	virtual ~CVSStencilLight();

	// IVisibilityListener
	virtual void onVisible( const dingus::CVisibilityLeaf& slot );

private:
	class CInternalLightPass : public CAbstractComponent, public dingus::IVisibilityListener, public dingus::IPortalListener {
	public:
		CInternalLightPass( dingus::CVisibilityContext::TVisDBID visDB, bool toClear, const dingus::SMatrix4x4& worldMatrix );

		// IVisibilityListener
		virtual void onVisible( const dingus::CVisibilityLeaf& slot );

		// IPortalListener
		virtual void onBeforePortal( const dingus::CPortal& portal );
		virtual void onAfterPortal( const dingus::CPortal& portal );

		virtual void update() { };

	protected:
		virtual void onAttach();
		virtual void onDetach();

	private:
		dingus::CVisibilityContext::TVisDBID	mVisDB;
		dingus::CPortal		mPortal;
		const dingus::SMatrix4x4* mWorldMatrix;
		bool	mToClear;
	};

private:
	CVisibilityComponent*	mVisComp;
	CInternalLightPass*		mShadowPass;
	CInternalLightPass*		mLightPass;
};

}; // namespace


#endif
