// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __CAMERA_CONTROLLER_H
#define __CAMERA_CONTROLLER_H

#include "../entity/Camera.h"
#include <dingus/math/Quaternion.h>
#include <dingus/math/Matrix4x4.h>
#include <dingus/math/Vector3.h>


namespace unco {


class CCameraController {
public:
	CCameraController();

	void setAffectedEntity( CCamera& e ) { mAffectedEntity = &e; };
	CCamera* getAffectedEntity() const { return mAffectedEntity; };

	void	arcBallBeginRotate( float x, float y ); // -1 to 1
	void	arcBallRotate( float x, float y ); // -1 to 1
	void	arcBallTranslate( float x, float y, float z ); // worldspace units
	void	arcBallSetRadius( float radius ) { mArcBallRadius = radius; }
	float	arcBallGetDistance() const { return mArcBallDistance; }
	void	arcBallSetDistance( float d ) { mArcBallDistance = d; }

private:
	dingus::SVector3 arcBallScreenToVector( float x, float y ) const;

private:
	CCamera*	mAffectedEntity;

	//
	// arc ball

	dingus::SMatrix4x4	mArcBallMatBefore;
	dingus::SQuaternion mArcBallQuatBefore; // quat before drag
	dingus::SQuaternion mArcBallQuatNow; // composite quat for current drag
	dingus::SVector3	mArcBallVecBegin; // drag begin vector
	float	mArcBallDistance; // distance arcball rotates about
	float	mArcBallRadius;
};


}; // namespace

#endif
