// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "RenderTarget.h"
#include <dingus/kernel/D3DDevice.h>
#include <dingus/utils/Errors.h>

using namespace unco;


CRenderTarget::CRenderTarget()
:	mActive(false),
	mClearBeforeUse( true ),
	mClearFlag( D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER ),
	mClearColor( 0xFF000000 ),
	mClearZValue( 1.0f ),
	mClearStencilValue( 0 ),

	mSettingViewport(false),

	mRenderTarget( NULL ),
	mZStencilTarget( NULL ),
	mPreviousRenderTarget( NULL ),
	mPreviousZStencilTarget( NULL )
{
}

void CRenderTarget::setClearValues( bool clearBeforeUse, DWORD clearFlag, D3DCOLOR clearColor, float zValue, DWORD stencilValue )
{
	mClearBeforeUse = clearBeforeUse;
	mClearFlag = clearFlag;
	mClearColor = clearColor;
	mClearZValue = zValue;
	mClearStencilValue = stencilValue;
}

void CRenderTarget::activate()
{
	mActive = true;

	IDirect3DDevice9* dx = dingus::gD3DDevice;
	assert( dx );

	HRESULT hres;	
	if( mRenderTarget ) {
		// TBD: only 0th RT for now
		hres = dx->GetRenderTarget( 0, &mPreviousRenderTarget );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to obtain render target" );
		}

		// TBD: only 0th RT for now
		hres = dx->SetRenderTarget( 0, mRenderTarget->getObject() );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to set render target" );
		}
	}
	if( mZStencilTarget ) {
		hres = dx->GetDepthStencilSurface( &mPreviousZStencilTarget );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to obtain depth-stencil surface" );
		}

		hres = dx->SetDepthStencilSurface( mZStencilTarget->getObject() );	
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to set depth-stencil surface" );
		}
	}
	
	if( mSettingViewport ) {
		dx->SetViewport( &mViewport );
	}

	if( mClearBeforeUse ) {
		// clear whole target area
		hres = dx->Clear( 0, NULL, mClearFlag, mClearColor, mClearZValue, mClearStencilValue );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to clear render target" );
		}
	}
}

void CRenderTarget::deactivate()
{
	if( !mActive )
		return;
	mActive = false;

	IDirect3DDevice9* dx = dingus::gD3DDevice;
	assert( dx );

	HRESULT hres;	

	if( mRenderTarget ) {
		// TBD: only 0th RT for now
		hres = dx->SetRenderTarget( 0, mPreviousRenderTarget );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to restore render target" );
		}
	}

	if( mZStencilTarget ) {
		hres = dx->SetDepthStencilSurface( mPreviousZStencilTarget );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to restore depth-stencil surface" );
		}
	}
}

void CRenderTarget::getSize( int& x, int& y ) const
{
	IDirect3DSurface9* surface;

	if( mRenderTarget->isNull() ) {
		IDirect3DDevice9* dx = dingus::gD3DDevice;
		assert( dx );

		HRESULT hres = dx->GetRenderTarget( 0, &surface );
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to get render target" );
		}
		assert( surface );
	} else {
		surface = mRenderTarget->getObject();
	}

	D3DSURFACE_DESC desc;
	HRESULT hres = surface->GetDesc( &desc );
	if( FAILED( hres ) ) {
		THROW_DXERROR( hres, "failed to get render target desc" );
	}

	if( mRenderTarget->isNull() ) {
		HRESULT hres = surface->Release();
		if( FAILED( hres ) ) {
			THROW_DXERROR( hres, "failed to release render target" );
		}
	}

	x = desc.Width;
	y = desc.Height;
}
