// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __RENDER_TARGET_H
#define __RENDER_TARGET_H

#include <dingus/kernel/Proxies.h>


namespace unco {


class CRenderTarget {
public:
	CRenderTarget();

	void activate();
	void deactivate();
	
	void setRenderTarget( dingus::CD3DSurface& renderTarget );
	void setZStencilTarget( dingus::CD3DSurface& zStencilTarget );
	void setClearValues(
		bool clearBeforeUse, DWORD clearFlag = D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
		D3DCOLOR clearColor = 0, float zValue = 1.0f, DWORD stencilValue = 0 );

	DWORD		getClearFlag() const { return mClearFlag; }
	D3DCOLOR	getClearColor() const { return mClearColor; }
	float		getClearZValue() const { return mClearZValue; }
	DWORD		getClearStencilValue() const { return mClearStencilValue; }

	void		getSize( int& x, int& y ) const;

	const D3DVIEWPORT9& getViewport() const { return mViewport; }
	D3DVIEWPORT9& getViewport() { return mViewport; }
	bool		isSettingViewport() const { return mSettingViewport; }
	void		setSettingViewport( bool sw ) { mSettingViewport = sw; }

private:
	bool		mActive;
	bool		mClearBeforeUse;
	DWORD		mClearFlag;
	D3DCOLOR	mClearColor;
	float		mClearZValue;
	DWORD		mClearStencilValue;
	D3DVIEWPORT9	mViewport;
	bool			mSettingViewport;

	dingus::CD3DSurface*	mRenderTarget;
	dingus::CD3DSurface*	mZStencilTarget;
	IDirect3DSurface9*		mPreviousRenderTarget;
	IDirect3DSurface9*		mPreviousZStencilTarget;
};


}; // namespace

#endif
