// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "TextRenderer.h"

using namespace unco;


CTextRenderer::CTextRenderer( dingus::CRenderableBillboards& bills, dingus::CD3DTexture& texture, const dingus::SVector2& tuArea0, const dingus::SVector2& tuArea1, char c0, int rows, int cols )
:	mBillboards( &bills ),
	mTexture(&texture),
	mTUArea0( tuArea0 ), mTUArea1( tuArea1 ), 
	mC0( c0 ), mRows( rows ), mCols( cols )
{
	mCharSize = dingus::SVector2( (mTUArea1.x-mTUArea0.x)/mCols, (mTUArea1.y-mTUArea0.y)/mRows );
	mHeightFactor = mCharSize.y / mCharSize.x;
}

CTextRenderer::CRenderedText* CTextRenderer::renderText( const std::string& text, const dingus::SVector2& globalC1, const dingus::SVector2& globalC2, D3DCOLOR color )
{
	assert( mBillboards );
	assert( mTexture );
	CRenderedText* rt = new CRenderedText();
	if( text.empty() )
		return rt;

	float y1 = globalC1.y;
	float y2 = globalC2.y;
	const float dy = y2-y1;

	dingus::SVector2 globalC = globalC1;
	float dx = (globalC2.x-globalC1.x) / text.size();
	for( int i = 0; i < text.size(); ++i ) {
		if( text[i] == '\n' ) {
			globalC.x = globalC1.x-dx;
			y1 += dy;
			y2 += dy;
		} else if( text[i] <= ' ' ) {
		} else if( text[i] >= '!' && text[i] <= '}' ) {
			int row = (text[i]-mC0) / mCols;
			int col = (text[i]-mC0) % mCols;
			char c = text[i];
			dingus::SBillboard& bill = mBillboards->addBill( *mTexture );
			bill.x1 = globalC.x;
			bill.y1 = y1;
			bill.x2 = globalC.x + dx;
			bill.y2 = y2;
			bill.tu1 = mTUArea0.x + mCharSize.x * col;
			bill.tv1 = mTUArea0.y + mCharSize.y * row;
			bill.tu2 = bill.tu1 + mCharSize.x;
			bill.tv2 = bill.tv1 + mCharSize.y;
			bill.color = color;
			rt->getBills().push_back( &bill );
		} else {
			assert( !"bad symbol" );
		}
		globalC.x += dx;
	}
	return rt;
}

float CTextRenderer::getHeight( const std::string& text, float width ) const
{
	assert( text.size() > 0 );
	return width / text.size() * mHeightFactor;
}

float CTextRenderer::getWidth( const std::string& text, float heigth ) const
{
	return heigth / mHeightFactor * text.size();
}

CTextRenderer::CRenderedText::~CRenderedText()
{
	for( int i = 0; i < mBills.size(); ++i )
		mBills[i]->discard();
}

void CTextRenderer::CRenderedText::setColor( D3DCOLOR color )
{
	for( int i = 0; i < mBills.size(); ++i )
		mBills[i]->color = color;
}
