// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __TEXT_RENDERER_H
#define __TEXT_RENDERER_H

#include <dingus/gfx/RenderableBillboards.h>
#include <dingus/math/Vector2.h>

namespace unco {

class CTextRenderer {
public:
	class CRenderedText : public boost::noncopyable {
	public:
		typedef std::vector<dingus::SBillboard*>	TBillPtrVector;
	public:
		~CRenderedText();
		void	setColor( D3DCOLOR color );
		const TBillPtrVector& getBills() const { return mBills; }
		TBillPtrVector& getBills() { return mBills; }
	private:
		TBillPtrVector	mBills;
	};

public:
	CTextRenderer( dingus::CRenderableBillboards& bills, dingus::CD3DTexture& texture, const dingus::SVector2& tuArea0, const dingus::SVector2& tuArea1, char c0, int rows, int cols );

	CRenderedText* renderText( const std::string& text, const dingus::SVector2& globalC1, const dingus::SVector2& globalC2, D3DCOLOR color );
	CRenderedText* renderTextHeight( const std::string& text, const dingus::SVector2& corner, float height, D3DCOLOR color ) {
		return renderText( text, corner, corner+dingus::SVector2(getWidth(text,height),height), color );
	}
	CRenderedText* renderTextWidth( const std::string& text, const dingus::SVector2& corner, float width, D3DCOLOR color ) {
		return renderText( text, corner, corner+dingus::SVector2(width,getHeight(text,width)), color );
	}



	float getHeight( const std::string& text, float width ) const;
	float getWidth( const std::string& text, float heigth ) const;

private:
	dingus::CRenderableBillboards*	mBillboards;
	dingus::CD3DTexture*			mTexture;
	dingus::SVector2 mTUArea0;
	dingus::SVector2 mTUArea1;
	dingus::SVector2 mCharSize;
	char	mC0;
	int		mRows;
	int		mCols;
	float	mHeightFactor;
};


}; // namespace

#endif