// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __APP_CONTEXT_H
#define __APP_CONTEXT_H


#include <dingus/utils/Singleton.h>

namespace unco {


class CAppContext : public dingus::CSingleton<CAppContext> {
public:
	int	getScreenWidth() const { return mScreenWidth; }
	int	getScreenHeight() const { return mScreenHeight; }
	const std::string&	getFPS() const { return mFPS; }
	const std::string&	getDeviceInfo() const { return mDeviceInfo; }

	void setInfo( int width, int height, const std::string& fps, const std::string& dev ) {
		mScreenWidth = width;
		mScreenHeight = height;
		mFPS = fps;
		mDeviceInfo = dev;
	}

	float getWindowAspect() const { return (float)mScreenWidth / (float)mScreenHeight; }

private:
	static CAppContext* createInstance() { return new CAppContext(); }
	static void deleteInstance( CAppContext& instance ) { delete &instance; }
	friend dingus::CSingleton<CAppContext>;
	CAppContext() : mScreenWidth(0), mScreenHeight(0) { }

private:
	int			mScreenWidth;
	int			mScreenHeight;
	std::string	mFPS;
	std::string	mDeviceInfo;
};


}; // namespace

#endif
