// --------------------------------------------------------------------------
// Unco project - an entity/component framework on top of Dingus project
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "ContextRegistry.h"

using namespace unco;


bool CContextRegistry::isContext( const std::string& name ) const
{
	TContextsMap::const_iterator it = mContexts.find( name );
	return ( it != mContexts.end() );
}

void* CContextRegistry::getContext( const std::string& name ) const
{
	TContextsMap::const_iterator it = mContexts.find( name );
	return ( it == mContexts.end() ) ? NULL : it->second;
}

void CContextRegistry::setContext( const std::string& name, void* ctx )
{
	assert( !isContext(name) );
	mContexts.insert( std::make_pair( name, ctx ) );
}

